/**
 * XML Web generátor – program na generování webových stránek
 * Copyright © 2012 František Kučera (frantovo.cz)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package cz.frantovo.xmlWebGenerator.makra;

import static cz.frantovo.xmlWebGenerator.NástrojeCLI.načtiProud;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * Provedeme skript a do stránky vložíme jeho výstup.
 *
 * @author František Kučera (frantovo.cz)
 */
public class Skriptování {

	/**
	 * klíč = jazyk – např. bash
	 * hodnota = interpret – např. /bin/bash
	 */
	private static final Map<String, String> interpreti;

	static {
		Map<String, String> podporovanýJazyk = new HashMap<String, String>();
		podporovanýJazyk.put("bash", "/bin/bash");
		podporovanýJazyk.put("perl", "/usr/bin/perl");
		podporovanýJazyk.put("php", "/usr/bin/php");
		podporovanýJazyk.put("python", "/usr/bin/python");
		interpreti = Collections.unmodifiableMap(podporovanýJazyk);
	}

	/**
	 * TODO: podporovat i složitější scénáře (např. kompilaci),
	 * než jen vložení do souboru a přidání správného záhlaví.
	 *
	 * @param skript program k vykonání
	 * @param jazyk programovací jazyk
	 * @param uriStránky URI aktuálně generované stránky → proměnná prostředí
	 * @param nadpisStránky nadpis stránky → proměnná prostředí
	 * @param perexStránky perex stránky → proměnná prostředí
	 * @return výstup příkazu
	 */
	public static String interpretuj(String skript, String jazyk, String uriStránky, String nadpisStránky, String perexStránky) {
		try {
			System.err.println("\tInterpretuji skript v jazyce: " + jazyk);
			String interpret = interpreti.get(jazyk);
			if (interpret == null) {
				System.err.println("Neznámý skriptovací jazyk: " + jazyk);
				return null;
			} else {
				File f = File.createTempFile("xml-web-generátor-", ".skript");
				f.deleteOnExit();

				PrintStream ps = new PrintStream(f);
				ps.print("#!");
				ps.println(interpret);
				ps.println();
				ps.print(skript);
				ps.close();

				f.setExecutable(true);

				String[] prostředí = new String[]{
					"LANG=" + System.getenv("LANG"),
					"USER=" + System.getenv("USER"),
					"XWG_STRANKA_URI=" + uriStránky,
					"XWG_STRANKA_SOUBOR=" + (new File(new URI(uriStránky)).getAbsolutePath()),
					"XWG_STRANKA_NADPIS=" + nadpisStránky,
					"XWG_STRANKA_PEREX=" + perexStránky
				};



				Runtime r = Runtime.getRuntime();
				Process p = r.exec(new String[]{f.getAbsolutePath()}, prostředí);

				String výsledek = načtiProud(p.getInputStream());
				String chyby = načtiProud(p.getErrorStream());

				p.waitFor();

				/**
				 * TODO: podporovat zvláštní návratový kód, kterým skript řekne,
				 * že výstupem je XML a má se vložit jako fragment do dokumentu,
				 * ne jako prostý text.
				 */
				if (p.exitValue() == 0) {
					if (chyby.length() > 0) {
						System.err.println("--- Cyhbový výstup skriptu -----");
						System.err.println(chyby);
						System.err.println("--------------------------------");
					}

					return výsledek.trim();
				} else {
					System.err.println("--- Standardní výstup skriptu: -----");
					System.err.println(výsledek);
					System.err.println("--- Cyhbový výstup skriptu: ---------");
					System.err.println(chyby);
					System.err.println("--------------------------------------");
					throw new RuntimeException("Návratová hodnota: " + p.exitValue());
				}
			}
		} catch (Exception e) {
			System.err.println("Došlo k chybě při vykonávání skriptu v jazyce: " + jazyk);
			System.err.println("--------");
			System.err.println(skript);
			System.err.println("--------");
			e.printStackTrace(System.err);
			return null;
		}
	}
}
