<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m xs">

	<!--
		Poznámky pod čarou
		******************
		Vloží do textu číslo (odkaz) a obsah elementu dá až na konec stránky pod čáru.
		Z poznámek vede také zpětný odkaz na místo, odkud bylo odkazováno.
		*
	-->
	<xsl:template match="m:podČarou">
		<xsl:variable name="číslo"><xsl:number level="any"/></xsl:variable>
		<sup class="podČarou-odkaz" id="podČarou-odkaz-{$číslo}">
			<a href="#{encode-for-uri('podČarou-poznámka')}-{$číslo}"><xsl:value-of select="$číslo"/></a>
		</sup>
	</xsl:template>

	<xsl:template name="poznámkyPodČarou">
		<xsl:if test="//m:podČarou">
			<div class="podČarou-poznámky" title="Poznámky pod čarou">
				<xsl:for-each select="//m:podČarou">
					<p id="podČarou-poznámka-{position()}">
						<a href="#{encode-for-uri('podČarou-odkaz')}-{position()}" class="podČarou-odkaz-zpět"><xsl:value-of select="position()"/>.</a>
						<xsl:apply-templates/>
					</p>
				</xsl:for-each>
			</div>
		</xsl:if>
	</xsl:template>

</xsl:stylesheet>

