<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.makra.Pre"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m j">

	<!--
		Zvýraznění syntaxe zdrojového kódu
		**********************************
		Ukázky zdrojového kódu budou mít zvýrazněnou syntaxi pro větší přehlednost.
		*
		@jazyk programovací jazyk, ve kterém je daný zdrojový kód 
		@src zdrojový kód nemusí být uvnitř elementu, ale můžeme se odkázat na externí soubor
		@odkaz nastavíme hodnotu „ano“, pokud chceme vložit odkaz na soubor je stažení
	-->
	<xsl:template match="m:pre">
		<xsl:call-template name="zvýrazniZdroják">
			<xsl:with-param name="zdroják" select="text()"/>
		</xsl:call-template>
	</xsl:template>

	<xsl:template match="m:pre[@src]">
		<xsl:call-template name="zvýrazniZdroják">
			<xsl:with-param name="zdroják" select="m:načti-textový-soubor(@src)"/>
		</xsl:call-template>
		<xsl:if test="@odkaz = 'ano'">
			<p class="zdroják-ke-stažení">
				<span>Stáhnout: <a href="{encode-for-uri(@src)}"><xsl:value-of select="@src"/></a></span>
			</p>
		</xsl:if>
	</xsl:template>

	<xsl:template name="zvýrazniZdroják">
		<xsl:param name="zdroják"/>
		<xsl:variable name="zvýrazněnýZdroják" select="j:zvýrazniSyntaxi($zdroják, @jazyk)"/>
		<xsl:choose>
			<xsl:when test="$zvýrazněnýZdroják">
				<xsl:comment>Následující kód je v jazyce <xsl:value-of select="@jazyk"/></xsl:comment>
				<xsl:value-of disable-output-escaping="yes" select="$zvýrazněnýZdroják"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message>Zvýraznění syntaxe se nezdařilo → bude vložen původní nezvýrazněný kód.</xsl:message>
				<pre><xsl:value-of select="$zdroják"/></pre>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>

