<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:a="http://www.w3.org/2005/Atom"
	xmlns:atom="http://www.w3.org/2005/Atom"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn j a">
	<xsl:output	method="xml" indent="yes" encoding="UTF-8"/>

	<xsl:template match="/">
		<stránka
			xmlns="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
			xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro">
			<skrytá>ano</skrytá>
			<nadpis>Seznam všech stránek</nadpis>
			<perex>Všechny stránky tohoto webu.</perex>
			<text xmlns="http://www.w3.org/1999/xhtml">
				<xsl:apply-templates select="a:feed/a:entry"/>
			</text>
		</stránka>
	</xsl:template>

	<xsl:template match="a:entry">
		<p style="seznamStranek">
			<xsl:variable name="základníUrl" select="//a:feed/a:link[not(@rel)]/@href"/>
			<a href="{replace(a:link/@href, $základníUrl, '')}"><xsl:value-of select="a:title"/></a>
			–
			<xsl:value-of select="a:summary"/>
			(<xsl:value-of select="format-dateTime(adjust-dateTime-to-timezone(a:updated),
				'[D1].[M1]. [Y0001] [H1]:[m01]')"/>)
		</p>
	</xsl:template>

</xsl:stylesheet>

