/**
 * XML Web generátor – program na generování webových stránek
 * Copyright © 2012 František Kučera (frantovo.cz)
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.frantovo.xmlWebGenerator.makra;

import java.io.IOException;
import java.io.PrintStream;
import static cz.frantovo.xmlWebGenerator.NástrojeCLI.*;

/**
 * Wiki syntaxe
 * 
 * @author František Kučera (frantovo.cz)
 */
public class Wiki {

	private static final String PŘÍKAZ_MARKDOWN = "markdown";

	/**
	 * Převede text ve wiki syntaxi do XHTML.
	 * @param wiki vstupní text v dané wiki syntaxi
	 * @param syntaxe null nebo volitelně syntaxe (markdown, texy)
	 * @return naformátované XHTML
	 * TODO: 
	 *	- vracet místo textu instanci com.icl.saxon.om.NodeInfo http://saxon.sourceforge.net/saxon6.5.3/extensibility.html
	 *  - nebo kontrolovat validitu vygenerovaného kódu (v současnosti se spoléháme na bezchybnost markdownu)
	 
	 */
	public static String formátujWiki(String wiki, String syntaxe) throws IOException {
		if (isPříkazDostupný(PŘÍKAZ_MARKDOWN)) {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_MARKDOWN});

			/**
			 * TODO: oříznout mezery na začátcích řádků, pokud je jich všude stejně?
			 * (odsazení v XML)
			 */
			PrintStream vstupProcesu = new PrintStream(p.getOutputStream());
			vstupProcesu.print(wiki);
			vstupProcesu.close();

			String chyby = načtiProud(p.getErrorStream());
			String xhtml = načtiProud(p.getInputStream());

			if (chyby.length() == 0) {
				return xhtml;
			} else {
				System.err.print("Při zpracování wiki syntaxe došlo k chybě: " + chyby);
				return null;
			}
		} else {
			System.err.println("Příkaz " + PŘÍKAZ_MARKDOWN + " není na vašem systému dostupný → nelze formátovat texty ve wiki syntaxi.");
			System.err.println("Můžete ho nainstalovat pomocí:");
			System.err.println("\t$ aptitude install markdown         # (Debian/Ubuntu)");
			System.err.println("\t$ yum install perl-Text-Markdown    # (Fedora/RedHat)");
			return null;
		}
	}
}

