<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="m xs">

	<!--
		Šifrování (Rot13)
		*****************
		Umožňuje vkládat „zašifrované“ části textu.
		Použijeme např. pro text, který vyzrazuje, jak skončí film.
		Pro zobrazení v čitelném tvaru je potřeba kliknout na tlačítko a text „dešifrovat“,
		takže si ho nepřečteme omylem, aniž bychom chtěli.
		*
		@algoritmus zatím je výchozím a jediným algoritmem Rot13
	-->
	<xsl:template match="m:šifra">
		<xsl:variable name="šifra-id">šifra-<xsl:number level="any"/></xsl:variable>
		<span class="rot13" title="Tento text je „zašifrován“ algoritmem Rot13, abyste si ho omylem nepřečetli. Pokud číst chcete, klikněte na tlačítko…">
			<span id="{$šifra-id}"><xsl:value-of select="m:rot13(text())"/></span>
			<a onclick="javascipt:xwg.rot13('{$šifra-id}'); return false;" href="#{encode-for-uri(' &gt;&gt; zobrazí „zašifrovaný“ text &lt;&lt;')}">↹</a>
		</span>
	</xsl:template>

	<xsl:function name="m:rot13" as="xs:string">
		<xsl:param name="vstup"/>
		<xsl:value-of select="translate($vstup, 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ', 'nopqrstuvwxyzabcdefghijklmNOPQRSTUVWXYZABCDEFGHIJKLM')"/>
	</xsl:function>

</xsl:stylesheet>

