/**
 * XML Web generátor – program na generování webových stránek
 * Copyright © 2012 František Kučera (frantovo.cz)
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * XML Web generátor – jmenný prostor 
 */
var xwg = { 
	/**
	 * Zašifruje/dešifruje obsah elementu pomocí Rot13.
	 * @param id ID elementu, jehož text chceme změnit.
	 */
	rot13: function(id) {
		var e = document.getElementById(id);
		e.textContent = e.textContent.rot13();
	}
};

/**
 * Vrací hodnotu textového řetězce zašifrovanou/dešifrovanou algoritmem Rot13 
 */
String.prototype.rot13 = function() {
	return this.replace(/[a-zA-Z]/g, function(z) {
		return String.fromCharCode((z <= "Z" ? 90 : 122) >= (z = z.charCodeAt(0) + 13) ? z : z - 26);
	});
};

