<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/2005/Atom"
	xmlns:g="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/prostor"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn g j">
	<xsl:output	method="xml" indent="yes" encoding="UTF-8"/>
	
	<xsl:template match="/">		
	
		<feed>
			<title><xsl:value-of select="g:web/g:název"/></title>
			<subtitle><xsl:value-of select="g:web/g:podtitul"/></subtitle>
			<link rel="self" href="{concat(g:web/g:url, 'atom.xml')}"/>
			<link href="{g:web/g:url}"/>			
			<updated><xsl:value-of select="current-dateTime()"/></updated>			
			<author>
				<name><xsl:value-of select="g:web/g:autor/g:jméno"/></name>
				<email><xsl:value-of select="g:web/g:autor/g:email"/></email>
			</author>
			<id><xsl:value-of select="concat('urn:uuid:', g:web/g:uuid)"/></id>
			
			<xsl:variable name="konfigurace" select="/"/>
			<xsl:for-each select="collection('../vstup/?select=*.xml')[empty(g:stránka/g:skrytá) or not(g:stránka/g:skrytá)]">
				<entry>
					<title><xsl:value-of select="g:stránka/g:nadpis"/></title>
					<xsl:variable name="soubor" select="replace(tokenize(document-uri(.), '/')[last()], '.xml', '')"/>
					<link href="{concat($konfigurace/g:web/g:url, encode-for-uri($soubor), '.xhtml')}" />
					<id><xsl:value-of select="concat('urn:', $konfigurace/g:web/g:kod ,':strana:', encode-for-uri($soubor))"/></id>
					<!--2010-10-09T20:51:04Z-->
					<updated><xsl:value-of select="j:posledníZměna(document-uri(.))"/></updated>
					<summary><xsl:value-of select="g:stránka/g:perex"/></summary>
				</entry>
			</xsl:for-each>
			
		</feed>
	</xsl:template>
	
</xsl:stylesheet>
