/**
 * XML Web generátor – program na generování webových stránek
 * Copyright © 2012 František Kučera (frantovo.cz)
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.frantovo.xmlWebGenerator.makra;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import static cz.frantovo.xmlWebGenerator.NástrojeCLI.*;

/**
 * Diagramy
 * 
 * @author František Kučera (frantovo.cz)
 */
public class Diagram {

	private static final String ADRESÁŘ_VÝSTUPNÍ = "výstup";
	private static final String PŘÍKAZ_DOT = "dot";
	private static int počítadloDiagramů = 0;
	private static String počítadloDiagramůKontext = ""; // aktuálně zpracovávaná stránka, při změně vynulujeme počítadlo

	/**
	 * Vytvoří obrázek s diagramem.
	 * @param zadání definice diagramu ve formátu dot
	 * @param vodorovně zda má být graf orientovaný vodorovně (funguje jen při <code>kompletní = false</code>)
	 * @param kompletní false, pokud k zadání chceme doplnit <code>digraph d {…}</code>
	 * @param kontext kam diagram patří – typicky název stránky, do které je vložen
	 * diagramy se pak budou číslovat v rámci tohoto kontextu 
	 * → nebude docházet k přepisování diagramů jiných stránek při částečném přegenerování webu.
	 * @param souborZadání null pokud chceme automatické číslování | nebo zadáme název souboru se zadáním diagramu – vygenerovaný diagram se pak bude jmenovat stejně
	 * @return název souboru bez přípony, který byl vytvořen, nebo null, pokud došlo k chybě.
	 */
	public static String vytvořDiagram(String zadání, boolean vodorovně, boolean kompletní, String kontext, String souborZadání) throws IOException, InterruptedException {
		if (isPříkazDostupný(PŘÍKAZ_DOT)) {

			String soubor;
			if (souborZadání == null) {
				if (kontext == null) {
					počítadloDiagramů++;
					soubor = "diagram-" + počítadloDiagramů;
				} else {
					// TODO: tohle by se mělo udělat v XSLT
					kontext = URLDecoder.decode(kontext, Charset.defaultCharset().name());

					// Každá stránka bude mít svoje diagramy číslované od 1
					if (!počítadloDiagramůKontext.equals(kontext)) {
						počítadloDiagramůKontext = kontext;
						počítadloDiagramů = 0;
					}

					počítadloDiagramů++;
					soubor = "diagram-" + kontext + "-" + počítadloDiagramů;
				}
			} else {
				soubor = souborZadání;
			}
			String souborSložka = ADRESÁŘ_VÝSTUPNÍ + File.separator + soubor;

			String zdroják;
			if (kompletní) {
				zdroják = zadání;
			} else {
				StringBuilder b = new StringBuilder(zadání.length() + 200);
				b.append("digraph d {\n");
				b.append("\tbgcolor=\"transparent\";\n");
				if (vodorovně) {
					b.append("\trankdir=LR;");
				}
				b.append(zadání);
				b.append("}\n");
				zdroják = b.toString();
			}

			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_DOT, "-T", "svg", "-o", souborSložka + ".svg"});

			/**
			 * TODO: generovat i PNG bitmapu
			 */
			PrintStream vstupProcesu = new PrintStream(p.getOutputStream());
			vstupProcesu.print(zdroják.toString());
			vstupProcesu.close();

			String chyby = načtiProud(p.getErrorStream());

			p.waitFor();

			if (chyby.length() == 0) {
				return soubor;
			} else {
				System.err.print("Při vytváření diagramu došlo k chybě: " + chyby);
				return null;
			}
		} else {
			System.err.println("Příkaz " + PŘÍKAZ_DOT + " není na vašem systému dostupný → diagramy nelze vygreslit.");
			System.err.println("Můžete ho nainstalovat pomocí:");
			System.err.println("\t$ aptitude install graphviz   # (Debian/Ubuntu)");
			System.err.println("\t$ yum install graphviz        # (Fedora/RedHat)");
			return null;
		}
	}
}
