/**
 * XML Web generátor – program na generování webových stránek
 * Copyright © 2012 František Kučera (frantovo.cz)
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package cz.frantovo.xmlWebGenerator.makra;

import java.io.IOException;
import java.io.PrintStream;
import static cz.frantovo.xmlWebGenerator.NástrojeCLI.*;

/**
 * Zvýrazňování syntaxe
 * 
 * @author František Kučera (frantovo.cz)
 */
public class Pre {

	private static final String PŘÍKAZ_PYGMENTIZE = "pygmentize";

	/**
	 * Zvýrazňuje syntaxi zdrojového kódu. Používá k tomu externí program/knihovnu pygmentize.
	 * @param zdroják zdrojový kód, který předáme příkazu pygmentize na standardním vstupu
	 * @param jazyk předáme příkazu pygmentize jako parametr -l &lt;lexer&gt;
	 * @return zvýrazněný text nebo null, pokud došlo k chybě.
	 * TODO: 
	 *	- vracet místo textu instanci com.icl.saxon.om.NodeInfo http://saxon.sourceforge.net/saxon6.5.3/extensibility.html
	 *  - nebo kontrolovat validitu vygenerovaného kódu (v současnosti se spoléháme na bezchybnost pygmentize)
	 */
	public static String zvýrazniSyntaxi(String zdroják, String jazyk) throws IOException, InterruptedException {
		if (jazyk == null || jazyk.length() == 0) {
			System.err.println("Není vyplněn atribut „jazyk“ → není jasné, jak se má zvýrazňovat.");
			return null;
		} else if (isPříkazDostupný(PŘÍKAZ_PYGMENTIZE)) {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_PYGMENTIZE, "-f", "html", "-l", jazyk});

			PrintStream vstupProcesu = new PrintStream(p.getOutputStream());
			vstupProcesu.print(zdroják);
			vstupProcesu.close();

			String výsledek = načtiProud(p.getInputStream());
			String chyby = načtiProud(p.getErrorStream());

			p.waitFor();

			if (chyby.length() == 0) {
				// Pozor: pygmentize má i při chybě návratový kód 0 → je potřeba kontrolovat chybový výstup.
				return výsledek;
			} else {
				System.err.print("Při zvýrazňování syntaxe došlo k chybě: " + chyby);
				return null;
			}
		} else {
			System.err.println("Příkaz " + PŘÍKAZ_PYGMENTIZE + " není na vašem systému dostupný → zvýrazňování syntaxe nebude fungovat.");
			System.err.println("Můžete ho nainstalovat pomocí:");
			System.err.println("\t$ aptitude install python-pygments   # (Debian/Ubuntu)");
			System.err.println("\t$ yum install python-pygments        # (Fedora/RedHat)");
			return null;
		}
	}

	/**
	 * Vygeneruje CSS styl pro zvýrazňování syntaxe.
	 * @return obsah CSS souboru nebo null, pokud generování nebylo možné
	 */
	public static String generujCssSyntaxe() throws IOException, InterruptedException {
		if (isPříkazDostupný(PŘÍKAZ_PYGMENTIZE)) {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_PYGMENTIZE, "-S", "default", "-f", "html"});
			return načtiProud(p.getInputStream());
		} else {
			return null;
		}
	}
}
