<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m xs">

	<!--
		Interní odkazy
		**************
		Slouží k vkládání odkazů na jiné stránky v rámci webu.
		*
		@href zadáváme jen název souboru bez přípony – s nezakódovanou češtinou a s mezerami
		@typ nevyplňujeme
	-->
	<xsl:template match="m:a[not(@typ)]">
		<a>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="href">
				<xsl:value-of select="encode-for-uri(concat(@href, $výstupníPřípona))"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>

	<xsl:variable name="tracURL" select="'https://trac.frantovo.cz/xml-web-generator'"/>	

	<!--
		Trac – wiki
		***********
		Odkazy na Trac našeho generátoru.
		*
		@href nečíselné parametry vedou do wiki
	-->
	<xsl:template match="m:a[@typ='trac' and not(number(@href))]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					$tracURL, '/wiki/', 
					m:escapuj-url-zachovej-lomítka(@href)
				)"/>
		</xsl:call-template>		
	</xsl:template>

	<!--
		Trac – úkoly
		************
		Odkazy na Trac našeho generátoru.
		*
		@href číselné parametry vedou na úkoly
	-->
	<xsl:template match="m:a[@typ='trac' and number(@href)]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					$tracURL, '/ticket/', 
					@href
				)"/>
		</xsl:call-template>
	</xsl:template>

	<!--
		Zdroják
		*******
		Odkazy zdrojový kód našeho generátoru.
		*
		@href název souboru
		@řádek číslo řádku (volitelně)
	-->
	<xsl:template match="m:a[@typ='zdroják' and (not(@řádek) or number(@řádek))]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					$tracURL, '/browser/', 
					m:escapuj-url-zachovej-lomítka(@href),
					'#L',
					(@řádek,'1')[1]
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	<!--
		Wikipedia
		*********
		Stránka v encyklopedii.
		*
		@href název stránky
		@jazyk kód jazyka (výchozí je čeština)
	-->
	<xsl:template match="m:a[@typ='wiki']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://secure.wikimedia.org/wikipedia/', (@jazyk,'cs')[1], '/wiki/', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	<!--
		Javadoc
		*******
		Dokumentace k javovským třídám.
		*
		@href jméno třídy včetně balíčku – např. java.lang.String
		@verze verze Javy, výchozí: 7
	-->
	<xsl:template match="m:a[@typ='javadoc']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'http://docs.oracle.com/javase/', (@verze,'7')[1], '/docs/api/',
					replace(@href, '\.', '/'),
					'.html'
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- 
		Seznam.cz
		*********
		Vyhledávání pomocí Seznamu.
		*
		@href náš dotaz
	-->
	<xsl:template match="m:a[@typ='seznam']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'http://search.seznam.cz/?q=', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Google.com
		**********
		Vyhledávání pomocí Googlu.
		*
		@href náš dotaz
	-->
	<xsl:template match="m:a[@typ='google']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://encrypted.google.com/search?q=', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>	
	</xsl:template>
	
	<!-- 
		Request for comments
		********************
		Internetové standardy – RFC.
		*
		@href číslo RFCčka
	-->
	<xsl:template match="m:a[@typ='rfc' and number(@href)]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://tools.ietf.org/html/rfc',
					@href
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	
	<xsl:template name="vložOdkaz">
		<xsl:param name="url"/>
		<a>
			<!-- Zachováme pouze povolené atributy: -->
			
			<xsl:copy-of select="@charset"/>
			<xsl:copy-of select="@coords"/>
			<xsl:copy-of select="@hreflang"/>
			<xsl:copy-of select="@name"/>
			<xsl:copy-of select="@rel"/>
			<xsl:copy-of select="@rev"/>
			<xsl:copy-of select="@shape"/>
			<xsl:copy-of select="@target"/> <!-- Pozor: nepatří do striktního XHTML -->
			
			<xsl:copy-of select="@accesskey"/>
			<xsl:copy-of select="@class"/>
			<xsl:copy-of select="@dir"/>
			<xsl:copy-of select="@id"/>
			<xsl:copy-of select="@lang"/>
			<xsl:copy-of select="@style"/>
			<xsl:copy-of select="@tabindex"/>
			<xsl:copy-of select="@title"/>
			<xsl:copy-of select="@xml:lang"/>
			
			<xsl:copy-of select="@onblur"/>
			<xsl:copy-of select="@onclick"/>
			<xsl:copy-of select="@ondblclick"/>
			<xsl:copy-of select="@onfocus"/>
			<xsl:copy-of select="@onmousedown"/>
			<xsl:copy-of select="@onmousemove"/>
			<xsl:copy-of select="@onmouseout"/>
			<xsl:copy-of select="@onmouseover"/>
			<xsl:copy-of select="@onmouseup"/>
			<xsl:copy-of select="@onkeydown"/>
			<xsl:copy-of select="@onkeypress"/>
			<xsl:copy-of select="@onkeyup"/>
			
			<xsl:attribute name="href"><xsl:value-of select="$url"/></xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>

</xsl:stylesheet>
