<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
xmlns="http://www.w3.org/1999/xhtml"
xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
exclude-result-prefixes="m">

	<!--
		Jednoduché tabulky
		******************
		Data zadáváme do těla elementu.
		Sloupce oddělujeme tabulátorem (může jich být víc, minimálně však jeden, mezery nestačí).
		První řádek se považuje za záhlaví (nadpisy sloupců).
		*
		@src volitelně můžeme data tabulky načítat ze souboru 
		@oddělovač regulární výraz, který odděluje sloupce – např. „\t+“ pro tabulátory (výchozí pro tabulky vložené přímo do stránky) nebo „;“ pro středník (výchozí pro tabulky načítané ze souboru) 
	-->
	<xsl:template match="m:tabulka">
		<xsl:call-template name="vykresliTabulku">
			<xsl:with-param name="zadání" select="text()"/>
			<xsl:with-param name="oddělovač" select="(@oddělovač, '\t+')[1]"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="m:tabulka[@src]">
		<xsl:call-template name="vykresliTabulku">
			<xsl:with-param name="zadání" select="unparsed-text(concat('../', $vstup, @src))"/>
			<xsl:with-param name="oddělovač" select="(@oddělovač, ';')[1]"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template name="vykresliTabulku">
		<xsl:param name="zadání"/>
		<xsl:param name="oddělovač"/>
		<table>
			<xsl:variable name="data" select="replace(replace($zadání, '^\s+', ''),'\s+$','')"/>
			<xsl:variable name="hlavička" select="substring-before($data, '&#10;')"/>
			<xsl:variable name="tělo" select="substring-after($data, '&#10;')"/>
			<thead>
				<tr>
					<xsl:for-each select="tokenize($hlavička, $oddělovač)">
						<xsl:if test="normalize-space(.)">
							<td><xsl:value-of select="normalize-space(.)"/></td>
						</xsl:if>
					</xsl:for-each>
				</tr>
			</thead>
			<tbody>
				<xsl:for-each select="tokenize($tělo, '\n')">
					<xsl:if test="normalize-space(.)">
						<tr>
							<xsl:for-each select="tokenize(., $oddělovač)">
								<xsl:if test="normalize-space(.)">
									<td><xsl:value-of select="normalize-space(.)"/></td>
								</xsl:if>
							</xsl:for-each>
						</tr>
					</xsl:if>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>

</xsl:stylesheet>

