<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m">

	<!--
		Interní odkazy
		**************
		Slouží k vkládání odkazů na jiné stránky v rámci webu.
		*
		@href zadáváme jen název souboru bez přípony – s nezakódovanou češtinou a s mezerami
		@typ nevyplňujeme
	-->
	<xsl:template match="m:a[not(@typ)]">
		<a>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="href">
				<xsl:value-of select="encode-for-uri(concat(@href, $výstupníPřípona))"/>
			</xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>

	<!--
		Trac – wiki
		***********
		Odkazy na Trac našeho generátoru.
		*
		@href nečíselné parametry vedou do wiki
	-->
	<xsl:template match="m:a[@typ='trac' and not(number(@href))]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://trac.frantovo.cz/xml-web-generator/wiki/', 
					replace(encode-for-uri(@href), '%2F', '/')
				)"/>
		</xsl:call-template>		
	</xsl:template>
	
	<!--
		Trac – úkoly
		************
		Odkazy na Trac našeho generátoru.
		*
		@href číselné parametry vedou na úkoly
	-->
	<xsl:template match="m:a[@typ='trac' and number(@href)]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://trac.frantovo.cz/xml-web-generator/ticket/', 
					@href
				)"/>
		</xsl:call-template>
	</xsl:template>

	<!--
		Wikipedia
		*********
		Stránka v encyklopedii
		*
		@href název stránky
		@jazyk kód jazyka (výchozí je čeština)
	-->
	<xsl:template match="m:a[@typ='wiki']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://secure.wikimedia.org/wikipedia/', (@jazyk,'cs')[1], '/wiki/', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	<!-- 
		Seznam.cz
		*********
		Vyhledávání pomocí Seznamu
		*
		@href náš dotaz
	-->
	<xsl:template match="m:a[@typ='seznam']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'http://search.seznam.cz/?q=', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>
	</xsl:template>

	<!-- 
		Google.com
		**********
		Vyhledávání pomocí Googlu
		*
		@href náš dotaz
	-->
	<xsl:template match="m:a[@typ='google']">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://encrypted.google.com/search?q=', 
					encode-for-uri(@href)
				)"/>
		</xsl:call-template>	
	</xsl:template>
	
	<!-- 
		Request for comments
		********************
		Internetové standardy – RFC
		*
		@href číslo RFCčka
	-->
	<xsl:template match="m:a[@typ='rfc' and number(@href)]">
		<xsl:call-template name="vložOdkaz">
			<xsl:with-param name="url" select="
				concat(
					'https://tools.ietf.org/html/rfc',
					@href
				)"/>
		</xsl:call-template>
	</xsl:template>
	
	
	<xsl:template name="vložOdkaz">
		<xsl:param name="url"/>
		<a>
			<xsl:copy-of select="@*"/>
			<xsl:attribute name="href"><xsl:value-of select="$url"/></xsl:attribute>
			<xsl:apply-templates/>
		</a>
	</xsl:template>

</xsl:stylesheet>
