<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m j">
    
	<!--
		Diagramy/grafy
		**************
		Můžeme vložit diagram – obrázek.
		Pro jejich vykreslování se používá Graphviz – diagramy zadáváme v jeho syntaxi.
		*
		@orientace „vodorovně“ nebo „svisle“ (výchozí)
		@nadpis můžeme uvést název diagramu
		@kompletní „ano“ → předpokládáme kompletní zdroják v GraphViz syntaxi (pak nemá smysl uvádět orientaci). Výchozí je však „ne“ → uživatel zadává jen „vnitřek“ grafu – např. „A -> B; B -> C;“.  
		@src zadání diagramu načteme ze souboru (potom je výchozí kompletní = 'ne')
	-->
	<xsl:template match="m:diagram">
		<xsl:call-template name="vložDiagram">
			<xsl:with-param name="zadání" select="text()"/>
			<xsl:with-param name="kompletní" select="@kompletní = 'ano'"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="m:diagram[@src]">
		<xsl:call-template name="vložDiagram">
			<xsl:with-param name="zadání" select="unparsed-text(concat('../', $vstup, @src))"/>
			<xsl:with-param name="kompletní" select="not(@kompletní) or @kompletní = 'ano'"/>
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="vložDiagram">
		<xsl:param name="zadání"/>
		<xsl:param name="kompletní"/>
		<xsl:variable name="souborDiagramu" select="j:vytvořDiagram($zadání, @orientace = 'vodorovně', $kompletní)"/>
		<xsl:choose>
			<xsl:when test="$souborDiagramu">
				<div class="diagram">
					<a href="{$souborDiagramu}.svg">
						<img
							src="{$souborDiagramu}.svg" 
							alt="Diagram {(@nadpis, $souborDiagramu)[1]} | pokud nevidíte obrázek, váš prohlížeč stojí za starou bačkoru"
							title="{@nadpis} (klikněte pro zobrazení samotného diagramu)"/>
					</a>
					<!-- 
						TODO: SVG+PNG:
						<xsl:variable name="svgDiagramu" select="document(concat($výstup, $souborDiagramu, '.svg'))/svg:svg"/>
						<object
						data="{$souborDiagramu}.svg"
						type="image/svg+xml"
						style="width: {$svgDiagramu/@width}; height: {$svgDiagramu/@height}">
						<img src="{$souborDiagramu}.png" alt="Diagram {$souborDiagramu}"/>
						</object>
					-->
					<xsl:if test="@nadpis">
						<p class="nadpis"><xsl:value-of select="@nadpis"/></p>
					</xsl:if>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">Při vytváření diagramu došlo k chybě.</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
