<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m j">
    
	<!--
		Diagramy/grafy
		**************
		Můžeme vložit diagram – obrázek.
		Pro jejich vykreslování se používá Graphviz – diagramy zadáváme v jeho syntaxi.
		*
		@orientace „vodorovně“ nebo „svisle“ (výchozí)
		@nadpis můžeme uvést název diagramu
		@kompletní „ano“ → předpokládáme kompletní zdroják v GraphViz syntaxi (pak nemá smysl uvádět orientaci). Výchozí je však „ne“ → uživatel zadává jen „vnitřek“ grafu – např. „A -> B; B -> C;“.  
		@src zadání diagramu načteme ze souboru (potom je výchozí kompletní = 'ne')
	-->
	<xsl:template match="m:diagram">
		<xsl:call-template name="vložDiagram">
			<xsl:with-param name="zadání" select="text()"/>
			<xsl:with-param name="kompletní" select="@kompletní = 'ano'"/>
		</xsl:call-template>
	</xsl:template>
	
	<xsl:template match="m:diagram[@src]">
		<xsl:call-template name="vložDiagram">
			<xsl:with-param name="zadání" select="unparsed-text(concat('../', $vstup, @src))"/>
			<xsl:with-param name="kompletní" select="not(@kompletní) or @kompletní = 'ano'"/>
		</xsl:call-template>
	</xsl:template>
    
    <xsl:template name="vložDiagram">
		<xsl:param name="zadání"/>
		<xsl:param name="kompletní"/>
		<xsl:variable name="souborDiagramu" select="j:vytvořDiagram($zadání, @orientace = 'vodorovně', $kompletní)"/>
		<xsl:choose>
			<xsl:when test="$souborDiagramu">
				<div class="diagram">
					<a href="{$souborDiagramu}.svg">
						<img
							src="{$souborDiagramu}.svg" 
							alt="Diagram {$souborDiagramu} | pokud nevidíte obrázek, váš prohlížeč stojí za starou bačkoru"
							title="{@nadpis} (klikněte pro zobrazení samotného diagramu)"/>
					</a>
					<!-- 
						TODO: SVG+PNG:
						<xsl:variable name="svgDiagramu" select="document(concat($výstup, $souborDiagramu, '.svg'))/svg:svg"/>
						<object
						data="{$souborDiagramu}.svg"
						type="image/svg+xml"
						style="width: {$svgDiagramu/@width}; height: {$svgDiagramu/@height}">
						<img src="{$souborDiagramu}.png" alt="Diagram {$souborDiagramu}"/>
						</object>
					-->
					<xsl:if test="@nadpis">
						<p class="nadpis"><xsl:value-of select="@nadpis"/></p>
					</xsl:if>
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">Při vytváření diagramu došlo k chybě.</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
