<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:s="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:k="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/konfigurace"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="fn h s k m j xs">
	
	<xsl:param name="vstup" select="'../vstup/'"/>
	<xsl:param name="výstup" select="'../výstup/'"/>
	<xsl:param name="vstupníPřípona" select="'.xml'"/>
	<xsl:param name="výstupníPřípona" select="'.xhtml'"/>
	<xsl:param name="vsuvkováPřípona" select="'.inc'"/>
	<xsl:param name="podporaZaostalýchProhlížečů" select="false()" as="xs:boolean"/>

	<xsl:variable name="konfigurace" select="document(concat($vstup, 'web.conf'))"/>
	
	<xsl:include href=".makra-seznam.xsl"/>
	
	
	<!-- Kopírujeme elementy, ale vynecháme nepoužité xmlns deklarace: -->
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
    </xsl:template>
    
    <!-- Varování pro případ, že jsme v režimu podpory pro zaostalé prohlížeče -->
    <xsl:template name="varováníRetardace">
    	<xsl:if test="$podporaZaostalýchProhlížečů">
			<xsl:comment>
				Generátor byl spuštěn v režimu podpory zaostalých prohlížečů.
				Uživatelům doporučujeme upgrade na skutečný WWW prohlížeč,
				jako je např. Firefox nebo Chromium (případně Opera či Safari).
			</xsl:comment>
    	</xsl:if>
    </xsl:template>

    <!-- Odkazy na JavaScript a kaskádové styly -->    
    <xsl:template match="k:web/k:js">    	
    	<script src="{text()}" type="text/javascript">
    		<xsl:call-template name="varováníRetardace"/>
    	</script>
    </xsl:template>
    <xsl:template match="k:web/k:css">
    	<link href="{text()}" type="text/css" rel="StyleSheet" />
    </xsl:template>
    
</xsl:stylesheet>
