<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m j">

    <!--
    	Zvýraznění syntaxe zdrojového kódu
    	**********************************
    	Ukázky zdrojového kódu budou mít zvýrazněnou syntaxi pro větší přehlednost.
    	*
    	@jazyk programovací jazyk, ve kterém je daný zdrojový kód 
    	@src zdrojový kód nemusí být uvnitř elementu, ale můžeme se odkázat na externí soubor
    	@odkaz nastavíme hodnotu „ano“, pokud chceme vložit odkaz na soubor je stažení
    -->    
    <xsl:template match="m:pre">
    	<xsl:call-template name="zvýrazniZdroják">
    		<xsl:with-param name="zdroják" select="text()"/>
    	</xsl:call-template>
    </xsl:template>
    
    <xsl:template match="m:pre[@src]">
    	<xsl:call-template name="zvýrazniZdroják">
    		<xsl:with-param name="zdroják" select="unparsed-text(concat('../', $vstup, @src))"/>
    	</xsl:call-template>
		<xsl:if test="@odkaz = 'ano'">
			<p class="zdroják-ke-stažení">
				<span>Stáhnout: <a href="{encode-for-uri(@src)}"><xsl:value-of select="@src"/></a></span>
			</p>
		</xsl:if>
    </xsl:template>
    
    <xsl:template name="zvýrazniZdroják">
    	<xsl:param name="zdroják"/>
    	<xsl:variable name="zvýrazněnýZdroják" select="j:zvýrazniSyntaxi($zdroják, @jazyk)"/>
    	<xsl:choose>
    		<xsl:when test="$zvýrazněnýZdroják">
    			<xsl:comment>Následující kód je v jazyce <xsl:value-of select="@jazyk"/></xsl:comment>
    			<xsl:value-of disable-output-escaping="yes" select="$zvýrazněnýZdroják"/>
    		</xsl:when>
    		<xsl:otherwise>
    			<xsl:message>Zvýraznění syntaxe se nezdařilo → bude vložen původní nezvýrazněný kód.</xsl:message>
    			<pre><xsl:value-of select="$zdroják"/></pre>
    		</xsl:otherwise>
    	</xsl:choose>    	
    </xsl:template>

</xsl:stylesheet>
