<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m">
	    
	<!--
		Jednoduché tabulky
		******************
		Data zadáváme do těla elementu.
		Sloupce oddělujeme tabulátorem (může jich být víc, minimálně však jeden, mezery nestačí).
		První řádek se považuje za záhlaví (nadpisy sloupců).
		*
	-->
    <xsl:template match="m:tabulka">
    	<table>
    		<xsl:variable name="data" select="replace(replace(text(), '^\s+', ''),'\s+$','')"/>
    		<xsl:variable name="hlavička" select="substring-before($data, '&#10;')"/>
    		<xsl:variable name="tělo" select="substring-after($data, '&#10;')"/>
    		<thead>
    			<tr>
    				<xsl:for-each select="tokenize($hlavička, '\t+')">
    					<xsl:if test="normalize-space(.)">
							<td><xsl:value-of select="normalize-space(.)"/></td>
						</xsl:if>
					</xsl:for-each>
    			</tr>
    		</thead>
    		<tbody>
				<xsl:for-each select="tokenize($tělo, '\n')">
					<xsl:if test="normalize-space(.)">
						<tr>
							<xsl:for-each select="tokenize(., '\t+')">
								<xsl:if test="normalize-space(.)">
									<td><xsl:value-of select="normalize-space(.)"/></td>
								</xsl:if>
							</xsl:for-each>
						</tr>
					</xsl:if>
				</xsl:for-each>
    		</tbody>
    	</table>    
    </xsl:template>

</xsl:stylesheet>

