<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:g="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/prostor"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	exclude-result-prefixes="fn h g">
	<xsl:output 
		method="xml" 
		indent="yes" 
		encoding="UTF-8"		
		doctype-public="-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" 
		doctype-system="http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd"/>
	
	<!-- Celý dokument: -->
	<xsl:template match="/">
		<html>
			<head>
				<title><xsl:value-of select="g:stránka/g:nadpis"/></title>				
			</head>
			<body>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/záhlaví.inc'))/g:stránka/h:text/node()"/>			
				<h1><xsl:value-of select="g:stránka/g:nadpis"/></h1>
				<xsl:apply-templates select="g:stránka/h:text/node()"/>
				<ul id="nabídka">
					<xsl:for-each select="collection('../vstup/?select=*.xml')[g:stránka/g:pořadí]">
						<xsl:sort select="empty(./g:stránka/g:pořadí)"/>
						<xsl:sort select="./g:stránka/g:pořadí"/>
						<li>
							<xsl:variable name="xmlSoubor" select="tokenize(document-uri(.), '/')[last()]"/>
							<xsl:variable name="xhtmlSoubor" select="replace($xmlSoubor, '.xml', '.xhtml')"/>
							<a href="{fn:encode-for-uri($xhtmlSoubor)}"><xsl:value-of select="./g:stránka/g:nadpis"/></a>
						</li>
					</xsl:for-each>
				</ul>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/zápatí.inc'))/g:stránka/h:text/node()"/>				
			</body>
		</html>
	</xsl:template>
	
	<!-- Kopírujeme elementy, ale vynecháme nepoužité xmlns deklarace: -->
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
    </xsl:template>

</xsl:stylesheet>
