<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:g="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/prostor"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn h g">
	<xsl:output 
		method="xml" 
		indent="yes" 
		encoding="UTF-8"		
		doctype-public="-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" 
		doctype-system="http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd"/>
	
	<xsl:template match="/">
		<html>
			<head>
				<title><xsl:value-of select="g:stránka/g:nadpis"/></title>				
			</head>
			<body>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/záhlaví.inc'))/g:stránka/h:text/node()"/>			
				<h1><xsl:value-of select="g:stránka/g:nadpis"/></h1>
				<xsl:apply-templates select="g:stránka/h:text/node()"/>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/zápatí.inc'))/g:stránka/h:text/node()"/>				
			</body>
		</html>
	</xsl:template>
	
	<xsl:template match="node()|@*">
		<xsl:copy>
			<xsl:apply-templates select="node()|@*"/>
		</xsl:copy>
	</xsl:template>

</xsl:stylesheet>
