package cz.frantovo.xmlWebGenerator;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

/**
 * Pomocné funkce pro práci s příkazy
 * @author fiki
 */
public class NástrojeCLI {
	
	private static final String PŘÍKAZ_WHICH = "which";

	/**
	 * Pomocí programu which zjistí, jestli je daný příkaz v systému přítomný.
	 * @param příkaz jehož přítomnost zjišťujeme
	 * @return true pokud příkaz v systému existuje
	 */
	public static boolean isPříkazDostupný(String příkaz) {
		try {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_WHICH, příkaz});
			p.waitFor();
			return p.exitValue() == 0;
		} catch (Exception e) {
			System.err.printf("Při zjišťování dostupnosti příkazu „%s“ došlo k chybě: %s", příkaz, e.getLocalizedMessage());
			return false;
		}
	}
	
	/**
	 * Čte proud dat dokud to jde a výsledek pak vrátí jako text.
	 * @param proud vstupní proud
	 * @return obsah proudu jako text
	 * @throws IOException 
	 */
	public static String načtiProud(InputStream proud) throws IOException {
		StringBuilder výsledek = new StringBuilder();
		BufferedReader buf = new BufferedReader(new InputStreamReader(proud));
		while (true) {
			String radek = buf.readLine();
			if (radek == null) {
				break;
			} else {
				výsledek.append(radek);
				výsledek.append("\n");
			}
		}
		return výsledek.toString();
	}
}
