package cz.frantovo.xmlWebGenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.net.URI;
import java.net.URISyntaxException;

/**
 * Knihovna funkcí volaných z XSLT.
 *  
 * TODO: časem rozdělit na více modulů (jmenných prostorů).
 * 
 * @author fiki
 */
public class Funkce {

	private static final String PŘÍKAZ_PYGMENTIZE = "pygmentize";
	private static final String PŘÍKAZ_WHICH = "which";

	/**
	 * Zjištuje, kdy byl naposledy daný soubor změněn.
	 * @param soubor cesta k souboru
	 * @return datum poslední změny
	 * @throws URISyntaxException
	 */
	public static Date posledníZměna(String soubor) throws URISyntaxException {
		URI uri = new URI(soubor);
		File f = new File(uri);
		return new Date(f.lastModified());
	}

	/**
	 * Zvýrazňuje syntaxi zdrojového kódu. Používá k tomu externí program/knihovnu pygmentize.
	 * @param zdroják zdrojový kód, který předáme příkazu pygmentize na standardním vstupu
	 * @param jazyk předáme příkazu pygmentize jako parametr -l &lt;lexer&gt;
	 * @return zvýrazněný text nebo null, pokud došlo k chybě.
	 * TODO: použít (?) místo textu instanci com.icl.saxon.om.NodeInfo http://saxon.sourceforge.net/saxon6.5.3/extensibility.html
	 */
	public static String zvýrazniSyntaxi(String zdroják, String jazyk) throws IOException, InterruptedException {
		if (jazyk == null || jazyk.length() == 0) {
			System.err.println("Není vyplněn atribut „jazyk“ → není jasné, jak se má zvýrazňovat.");
			return null;
		} else if (isPrikazDostupny(PŘÍKAZ_PYGMENTIZE)) {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_PYGMENTIZE, "-f", "html", "-l", jazyk});

			PrintStream vstupProcesu = new PrintStream(p.getOutputStream());
			vstupProcesu.print(zdroják);
			vstupProcesu.close();

			String výsledek = načtiProud(p.getInputStream());
			String chyby = načtiProud(p.getErrorStream());

			p.waitFor();

			if (chyby.length() == 0) {
				// Pozor: pygmentize má i při chybě návratový kód 0 → je potřeba kontrolovat chybový výstup.
				return výsledek;
			} else {
				System.err.print("Při zvýrazňování syntaxe došlo k chybě: " + chyby);
				return null;
			}
		} else {
			System.err.println("Příkaz " + PŘÍKAZ_PYGMENTIZE + " není na vašem systému dostupný → zvýrazňování syntaxe nebude fungovat.");
			System.err.println("Můžete ho nainstalovat pomocí:");
			System.err.println("\t$ aptitude install python-pygments   # (Debian/Ubuntu)");
			System.err.println("\t$ yum install python-pygments        # (Fedora/RedHat)");
			return null;
		}
	}

	/**
	 * Čte proud dat dokud to jde a výsledek pak vrátí jako text.
	 * @param proud vstupní proud
	 * @return obsah proudu jako text
	 * @throws IOException 
	 */
	private static String načtiProud(InputStream proud) throws IOException {
		StringBuilder výsledek = new StringBuilder();
		BufferedReader buf = new BufferedReader(new InputStreamReader(proud));
		while (true) {
			String radek = buf.readLine();
			if (radek == null) {
				break;
			} else {
				výsledek.append(radek);
				výsledek.append("\n");
			}
		}
		return výsledek.toString();
	}

	/**
	 * Pomocí programu which zjistí, jestli je daný příkaz v systému přítomný.
	 * @param příkaz jehož přítomnost zjišťujeme
	 * @return true pokud příkaz v systému existuje
	 */
	private static boolean isPrikazDostupny(String příkaz) {
		try {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{PŘÍKAZ_WHICH, příkaz});
			p.waitFor();
			return p.exitValue() == 0;
		} catch (Exception e) {
			System.err.printf("Při zjišťování dostupnosti příkazu „%s“ došlo k chybě: %s", příkaz, e.getLocalizedMessage());
			return false;
		}
	}
}
