package cz.frantovo.xmlWebGenerator;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.net.URI;
import java.net.URISyntaxException;

public class Funkce {

	public static Date posledníZměna(String soubor) throws URISyntaxException {
		return new Date(new File(new URI(soubor)).lastModified());
	}

	/**
	 * Zvýrazňuje syntaxi zdrojového kódu. Používá k tomu externí program/knihovnu pygmentize.
	 * @param zdroják zdrojový kód, který předáme příkazu pygmentize na standardním vstupu
	 * @param jazyk předáme příkazu pygmentize jako parametr -l &lt;lexer&gt;
	 * @return TODO: použít (?) místo textu instanci com.icl.saxon.om.NodeInfo http://saxon.sourceforge.net/saxon6.5.3/extensibility.html
	 */
	public static String zvýrazniSyntaxi(String zdroják, String jazyk) throws IOException, InterruptedException {
		String příkaz = "pygmentizexxx";

		if (isPrikazDostupny(příkaz)) {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{příkaz, "-f", "html", "-l", jazyk});

			PrintStream vstupProcesu = new PrintStream(p.getOutputStream());
			vstupProcesu.print(zdroják);
			vstupProcesu.close();

			String výsledek = načtiProud(p.getInputStream());
			String chyby = načtiProud(p.getErrorStream());

			p.waitFor();

			if (chyby.length() == 0) {
				return výsledek;
			} else {
				System.err.println("Při zvýrazňování syntaxe došlo k chybě: " + chyby);
				return "______chyba_____";
			}
		} else {
			System.err.println("Příkaz " + příkaz + " není na vašem systému dostupný → zvýrazňování syntaxe nebude fungovat.");
			System.err.println("Můžete ho nainstalovat pomocí: aptitude install python-pygments");
			// TODO: příkaz pro Fedoru/RedHat
			// TODO: vracet escapovaný zdroják v <pre/>
			return "__xxx____chyba_____";
		}
	}

	private static String načtiProud(InputStream proud) throws IOException {
		StringBuilder výsledek = new StringBuilder();
		BufferedReader buf = new BufferedReader(new InputStreamReader(proud));
		while (true) {
			String radek = buf.readLine();
			if (radek == null) {
				break;
			} else {
				výsledek.append(radek);
				výsledek.append("\n");
			}
		}
		return výsledek.toString();
	}

	private static boolean isPrikazDostupny(String příkaz) {
		try {
			Runtime r = Runtime.getRuntime();
			Process p = r.exec(new String[]{"which", příkaz});
			p.waitFor();
			return p.exitValue() == 0;
		} catch (Exception e) {
			return false;
		}
	}
}
