<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:a="http://www.w3.org/2005/Atom"
	xmlns:atom="http://www.w3.org/2005/Atom"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	exclude-result-prefixes="fn j a">
	<xsl:output	method="xml" indent="yes" encoding="UTF-8"/>
	
	<xsl:template match="/">
		<stránka
			xmlns="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
			xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro">
			<skrytá>ano</skrytá>
			<nadpis>Seznam všech stránek</nadpis>
			<perex>Všechny stránky tohoto webu.</perex>			
			<text xmlns="http://www.w3.org/1999/xhtml">				
				<xsl:apply-templates select="a:feed/a:entry"/>								
			</text>	
		</stránka>		
	</xsl:template>
	
	<xsl:template match="a:entry">
		<p style="seznamStranek">
			<xsl:variable name="základníUrl" select="//a:feed/a:link[not(@rel)]/@href"/>
			<a href="{replace(a:link/@href, $základníUrl, '')}"><xsl:value-of select="a:title"/></a>
			–
			<xsl:value-of select="a:summary"/>
			(<xsl:value-of select="format-dateTime(a:updated,
				'[D01].[M01]. [Y0001] [H01]:[m01]')"/>)
		</p>				
	</xsl:template>
	
</xsl:stylesheet>
