<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" indent="yes" encoding="UTF-8" doctype-public="-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" doctype-system="http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd"/>
	
	<xsl:template match="/">
		<html>
			<head>
				<title><xsl:value-of select="stránka/@titulek"/></title>
			</head>
			<body>
				<xsl:choose>
					<xsl:when test="stránka/nadpis">						
						<!--
							Element nadpis je nepovinný, můžeme ho použít, pokud zde chceme formátovaný text
							nebo prostě jiný text než v titulku stránky.						
						-->
						<h1><xsl:value-of select="stránka/nadpis"/></h1>
					</xsl:when>
					<xsl:otherwise>
						<h1><xsl:value-of select="stránka/@titulek"/></h1>
					</xsl:otherwise>
				</xsl:choose>
			
				<!--
					Vložíme obsah stránky:
				-->				
				<xsl:apply-templates select="stránka/node()"/>
			</body>
		</html>
	</xsl:template>
	
	
	<xsl:template match="node()|@*">
	  <xsl:copy>
		<xsl:apply-templates select="node()|@*"/>
	  </xsl:copy>
  	</xsl:template>

</xsl:stylesheet>
