<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:s="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:k="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/konfigurace"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="fn h s k m j xs">
	
	<xsl:param name="vstup" select="'../vstup/'"/>
	<xsl:param name="výstup" select="'../výstup/'"/>
	<xsl:param name="vstupníPřípona" select="'.xml'"/>
	<xsl:param name="výstupníPřípona" select="'.xhtml'"/>
	<xsl:param name="vsuvkováPřípona" select="'.inc'"/>
	<xsl:param name="podporaZaostalýchProhlížečů" select="false()" as="xs:boolean"/>
	
	<xsl:variable name="konfigurace" select="document(concat($vstup, 'web.conf'))"/>
	
	<xsl:include href=".makra-seznam.xsl"/>
	
	<!--
		Kopírujeme elementy, ale vynecháme nepoužité xmlns deklarace:
	-->
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
	</xsl:template>

	<!--
		Varování pro případ, že jsme v režimu podpory pro zaostalé prohlížeče
	-->
	<xsl:template name="varováníRetardace">
		<xsl:if test="$podporaZaostalýchProhlížečů">
			<xsl:comment>
				Generátor byl spuštěn v režimu podpory zaostalých prohlížečů.
				Uživatelům doporučujeme upgrade na skutečný WWW prohlížeč,
				jako je např. GNU IceCat, Firefox nebo rekonq.
			</xsl:comment>
		</xsl:if>
	</xsl:template>

	<!--
		Odkazy na JavaScript a kaskádové styly
	-->
	<xsl:template match="k:web/k:js">
		<script src="{text()}" type="text/javascript">
			<xsl:call-template name="varováníRetardace"/>
		</script>
	</xsl:template>
	<xsl:template match="k:web/k:css">
		<link href="{text()}" type="text/css" rel="StyleSheet" />
	</xsl:template>
	
	<!--
		Metainformace o autorovi a popisu stránky
	-->
	<xsl:template match="k:web/k:autor/k:jméno">
		<meta content="{text()}" name="author"/>
	</xsl:template>
	<xsl:template match="s:stránka/s:perex">
		<meta content="{text()}" name="description"/>
	</xsl:template>
	<xsl:template match="s:stránka/s:klíčováSlova">
		<xsl:element name="meta">
			<xsl:attribute name="content">
				<xsl:for-each select="s:slovo">
					<xsl:value-of select="text()"/>
					<xsl:if test="not(position() = last())">, </xsl:if>
				</xsl:for-each>
			</xsl:attribute>
			<xsl:attribute name="name">keywords</xsl:attribute>
		</xsl:element>
	</xsl:template>

	<!--
		Vloží nečíslovaný seznam obsahující hlavní nabídku webu (seznam stránek)
		Pro potřeby CSS stylování má nabídka @id='nabídka'
	-->
	<xsl:template name="vložNabídku">
		<ul id="nabídka">
			<xsl:for-each select="collection(concat('./', $vstup ,'/?select=*', $vstupníPřípona))[s:stránka/s:pořadí]">
				<xsl:sort select="empty(./s:stránka/s:pořadí)"/>
				<xsl:sort select="./s:stránka/s:pořadí"/>
				<li>
					<xsl:variable name="xmlSoubor" select="tokenize(document-uri(.), '/')[last()]"/>
					<xsl:variable name="xhtmlSoubor" select="replace($xmlSoubor, $vstupníPřípona, $výstupníPřípona)"/>
					<a href="{fn:encode-for-uri($xhtmlSoubor)}"><xsl:value-of select="./s:stránka/s:nadpis"/></a>
				</li>
			</xsl:for-each>
		</ul>
	</xsl:template>

	<!--
		Vloží záhlaví (společné pro všechny stránky)
		Pro potřeby CSS stylování má @id='záhlaví'
	-->
	<xsl:template name="vložZáhlaví">
		<div id="záhlaví">
			<xsl:apply-templates select="document(fn:encode-for-uri(concat($vstup, 'záhlaví', $vsuvkováPřípona)))/s:stránka/h:text/node()"/>
		</div>
	</xsl:template>

	<!--
		Vloží zápatí (společné pro všechny stránky)
		Pro potřeby CSS stylování má @id='zápatí'
	-->
	<xsl:template name="vložZápatí">
		<div id="zápatí">
			<xsl:apply-templates select="document(fn:encode-for-uri(concat($vstup, 'zápatí', $vsuvkováPřípona)))/s:stránka/h:text/node()"/>
		</div>
	</xsl:template>

	<!--
		Vrací cestu v URL kódování, ale lomítka nekóduje
	-->
	<xsl:function name="m:escapuj-url-zachovej-lomítka" as="xs:string">
		<xsl:param name="cesta"/>
		<xsl:value-of select="replace(encode-for-uri($cesta), '%2F', '/')"/>
	</xsl:function>

	<!--
		Vrací obsah textového souboru ve vstupním adresáři.
		Obvykle jako parametr předáváme atribut „src“.
	-->
	<xsl:function name="m:načti-textový-soubor" as="xs:string">
		<xsl:param name="soubor"/>
		<xsl:value-of select="unparsed-text(concat($vstup, $soubor))"/>
	</xsl:function>

</xsl:stylesheet>

