<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:s="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:k="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/konfigurace"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.Funkce"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="fn h s k m j xs">
	<xsl:output 
		method="xml" 
		indent="yes" 
		encoding="UTF-8"
		doctype-public="-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" 
		doctype-system="http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd"/>
	<xsl:include href="stránka-společné.xsl"/>
	
	<!-- 
		Šablona stránky
		***************
	-->
	<xsl:template match="/">
		<html>
			<head>
				<xsl:if test="$podporaZaostalýchProhlížečů">
					<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=utf-8" />
				</xsl:if>
				<title>
					<xsl:choose>
						<xsl:when test="s:stránka/s:nadpis/text() = $konfigurace/k:web/k:název/text()"><xsl:value-of select="s:stránka/s:nadpis"/></xsl:when>
						<xsl:otherwise><xsl:value-of select="s:stránka/s:nadpis"/> – <xsl:value-of select="$konfigurace/k:web/k:název"/></xsl:otherwise>
					</xsl:choose>
				</title>
				<link title="Novinky (Atom)" href="atom.xml" type="application/atom+xml" rel="alternate"/>
				<link title="Novinky (RSS)"  href="rss.xml"  type="application/rss+xml"  rel="alternate"/>
				<xsl:apply-templates select="$konfigurace/k:web/k:autor/k:jméno"/>
				<xsl:apply-templates select="s:stránka/s:perex"/>
				<xsl:apply-templates select="s:stránka/s:klíčováSlova"/>
				<xsl:apply-templates select="$konfigurace/k:web/k:js"/>
				<xsl:apply-templates select="$konfigurace/k:web/k:css"/>
			</head>
			<body>
				<div id="tělo">
					<xsl:call-template name="vložZáhlaví"/>
					<div id="vnitřek">
						<h1><xsl:value-of select="s:stránka/s:nadpis"/></h1>
						<xsl:call-template name="vložNabídku"/>
						<div id="text">
							<xsl:apply-templates select="s:stránka/h:text/node()"/>
						</div>
					</div>
					<xsl:call-template name="poznámkyPodČarou"/>
					<xsl:call-template name="vložZápatí"/>
				</div>
			</body>
		</html>
	</xsl:template>

</xsl:stylesheet>

