<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:s="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:k="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/konfigurace"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	xmlns:xs="http://www.w3.org/2001/XMLSchema"
	exclude-result-prefixes="fn h s k m xs">
	
	<!-- Vypíše verze z verzovacího systému: -->
	<xsl:template match="m:hg-verze">

		<xsl:variable name="zadáníSkriptu">
			<m:skript jazyk="bash" výstup="xml">hg log --style xml</m:skript>
		</xsl:variable>

		<xsl:variable name="výstupSkriptu">
			<xsl:apply-templates select="$zadáníSkriptu/*"/>
		</xsl:variable>

		<table>
			<thead>
				<tr>
					<td>Číslo verze</td>
					<td>Datum vydání</td>
				</tr>
			</thead>
			<tbody style="text-align: right;">
				<xsl:for-each select="$výstupSkriptu/h:log/h:logentry[h:tag[starts-with(text(), 'v')]]">
					<tr>
						<td><xsl:value-of select="substring(h:tag/text(), 2)"/></td>
						<td><xsl:value-of select="format-dateTime(h:date, '[D]. [M]. [Y0001]')"/></td>
					</tr>
				</xsl:for-each>
			</tbody>
		</table>
	</xsl:template>

</xsl:stylesheet>

