<?xml version="1.0" encoding="UTF-8"?>
<!--
XML Web generátor – program na generování webových stránek
Copyright © 2012 František Kučera (frantovo.cz)

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
-->
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:m="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/makro"
	xmlns:j="java:cz.frantovo.xmlWebGenerator.makra.Skriptování"
	xmlns:k="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/konfigurace"
	xmlns:s="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/strana"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	exclude-result-prefixes="m j k s">

	<!--
		Skriptování
		***********
		Provedeme skript zadaný v těle elementu nebo v souboru a jeho výstup vložíme do stránky.
		*
		@jazyk programovací jazyk, např. bash, perl, php (nepovinné, pokud je vyplněn atribut src)
		@výstup formát výstupu skriptu: text (výchozí) | xml (musí být validním fragmentem XML)
		@src soubor se skriptem/programem (volitelný parametr – buď zadáme skript do těla elementu, nebo nastavíme tento atribut)
	-->
	<xsl:template match="m:skript">
		
		<xsl:variable name="režim" select="$konfigurace/k:web/k:skriptování/k:režim/text()"/>
		
		<xsl:choose>
			<xsl:when test="$režim = 'povolit'">
				<xsl:variable name="výstupSkriptu" select="j:interpretuj(
																	text(),
																	@src,
																	@jazyk,
																	@výstup,
																	(document-uri(/), resolve-uri('.'))[1],
																	//s:stránka/s:nadpis/text(),
																	//s:stránka/s:perex/text()
																)"/>
				<xsl:choose>
					<xsl:when test="$výstupSkriptu">
						<xsl:choose>
							<xsl:when test="@výstup = 'xml'"><xsl:value-of select="$výstupSkriptu" disable-output-escaping="yes"/></xsl:when>
							<xsl:otherwise><xsl:value-of select="$výstupSkriptu"/></xsl:otherwise>
						</xsl:choose>
					</xsl:when>
					<xsl:otherwise>
						<xsl:message terminate="yes">Při interpretaci skriptu došlo k chybě.</xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:when>

			<xsl:when test="$režim = 'zakázat'">
				<xsl:message terminate="yes">Stránka obsahuje skripty, ale skripty jsou zakázané → je potřeba je odstranit nebo upravit nastavení ve web.conf.</xsl:message>
			</xsl:when>
			<xsl:when test="$režim = 'ignorovat'">
				<xsl:message>Stránka obsahuje skripty, ale skripty jsou ignorovány – změnu lze provést ve web.conf.</xsl:message>
			</xsl:when>
			<xsl:when test="$režim = 'vložit' and @výstup = 'xml'">
				<xsl:message>Není možné jen tak vložit text, který měl mít výstup ve formátu XML – změnu lze provést ve web.conf</xsl:message>
			</xsl:when>
			<xsl:when test="$režim = 'vložit'">
				<span class="vloženýNeinterpretovanýSkript jazyk-{@jazyk}">
					<xsl:value-of select="text()"/>
				</span>
			</xsl:when>
			<xsl:otherwise><!-- varovat = výchozí možnost -->
				<xsl:choose>
					<xsl:when test="@výstup = 'xml'">
						<xsl:message>Není možné možné vložit varování na místo, kde měl být skript generující XML – změnu lze provést ve web.conf</xsl:message>
					</xsl:when>
					<xsl:otherwise>
						<xsl:text>[VAROVÁNÍ (</xsl:text>
						<xsl:value-of select="@jazyk"/>
						<xsl:text>): skripty jsou vypnuté – lze je zapnout ve web.conf]</xsl:text>
						<xsl:message>Skript se neinterpretuje a vkládáme varování do stránky – změnu lze provést ve web.conf</xsl:message>
					</xsl:otherwise>
				</xsl:choose>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>

