<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
	xmlns="http://www.w3.org/1999/xhtml"
	xmlns:h="http://www.w3.org/1999/xhtml"
	xmlns:g="https://trac.frantovo.cz/xml-web-generator/wiki/xmlns/prostor"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:fn="http://www.w3.org/2005/xpath-functions"
	xmlns:svg="http://www.w3.org/2000/svg"
	exclude-result-prefixes="fn h g">
	<xsl:output 
		method="xml" 
		indent="yes" 
		encoding="UTF-8"		
		doctype-public="-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN" 
		doctype-system="http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd"/>
		
	<xsl:param name="konfigurák"/>
	
	<!-- Celý dokument: -->
	<xsl:template match="/">
		<xsl:variable name="konfigurace" select="document($konfigurák)"/>
		<html>
			<head>
				<title><xsl:value-of select="g:stránka/g:nadpis"/></title>
				<link title="Novinky (Atom)" href="atom.xml" type="application/atom+xml" rel="alternate"/>
				<link title="Novinky (RSS)"  href="rss.xml"  type="application/rss+xml"  rel="alternate"/>
				<xsl:apply-templates select="$konfigurace/g:web/g:js"/>
				<xsl:apply-templates select="$konfigurace/g:web/g:css"/>				
			</head>
			<body>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/záhlaví.inc'))/g:stránka/h:text/node()"/>			
				<h1><xsl:value-of select="g:stránka/g:nadpis"/></h1>
				<xsl:apply-templates select="g:stránka/h:text/node()"/>
				<ul id="nabídka">
					<xsl:for-each select="collection('../vstup/?select=*.xml')[g:stránka/g:pořadí]">
						<xsl:sort select="empty(./g:stránka/g:pořadí)"/>
						<xsl:sort select="./g:stránka/g:pořadí"/>
						<li>
							<xsl:variable name="xmlSoubor" select="tokenize(document-uri(.), '/')[last()]"/>
							<xsl:variable name="xhtmlSoubor" select="replace($xmlSoubor, '.xml', '.xhtml')"/>
							<a href="{fn:encode-for-uri($xhtmlSoubor)}"><xsl:value-of select="./g:stránka/g:nadpis"/></a>
						</li>
					</xsl:for-each>
				</ul>
				<xsl:apply-templates select="document(fn:encode-for-uri('../vstup/zápatí.inc'))/g:stránka/h:text/node()"/>				
			</body>
		</html>
	</xsl:template>
	
	<!-- Kopírujeme elementy, ale vynecháme nepoužité xmlns deklarace: -->
	<xsl:template match="*">
		<xsl:element name="{name()}">
			<xsl:copy-of select="@*"/>
			<xsl:apply-templates/>
		</xsl:element>
    </xsl:template>
    
    <xsl:template match="g:web/g:js">
    	<script src="{text()}" type="text/javascript" />
    </xsl:template>
    <xsl:template match="g:web/g:css">
    	<link href="{text()}" type="text/css" rel="StyleSheet" />
    </xsl:template>
    
    <!-- Ukázka vlastního „makra“: -->
    <xsl:template match="g:měřák">
    	<xsl:variable name="hodnota" select="number(@hodnota)"/>
    	<xsl:variable name="šířkaGrafu" select="128"/>
		<xsl:choose>			
			<xsl:when test="$hodnota &gt;= 0 and $hodnota &lt;= 100">				
				<div style="border: 1px solid black; width: {$šířkaGrafu}px; height: 16px; padding: 0px; text-align: center; background-color: #cfc;">			
					<div style="margin: 0px; background-color: #A4E666; width: {@hodnota*$šířkaGrafu div 100}px; height: 16px;"/>
					<p style="margin: 0px; font-size: 12px; position: relative; top: -15px;">
						<xsl:value-of select="@hodnota"/>/100
					</p>	
				</div>
			</xsl:when>
			<xsl:otherwise>
				<xsl:message terminate="yes">Hodnota měřáku musí být nejméně 0 a nejvíce 100 (udává procenta).</xsl:message>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

</xsl:stylesheet>
