package cz.frantovo.sql.vyuka.dto;

/**
 * Hláška úspěšného provedení.
 * @author fiki
 */
public class Hlaska {

    public enum Typ {

        OK,
        Tip,
        Varovani,
        Chyba
    }
    private String text;
    private Typ typ;
    private boolean escapovat = true;

    /**
     * SQL hláška
     * @param text text hlášky
     * @param typ ovlivňuje ikonku
     * @param escapovat zda máme escapovat text kvůli HTML značkám
     */
    public Hlaska(String text, Typ typ, boolean escapovat) {
        this.text = text;
        this.typ = typ;
        this.escapovat = escapovat;
    }

    /**
     * SQL hláška
     * @param text text hlášky
     * @param typ ovlivňuje ikonku
     */
    public Hlaska(String text, Typ typ) {
        this.text = text;
        this.typ = typ;
        this.escapovat = true;
    }

    public String getText() {
        return text;
    }

    public void setText(String hodnota) {
        this.text = hodnota;
    }

    public Typ getTyp() {
        return typ;
    }

    public void setTyp(Typ typ) {
        this.typ = typ;
    }

    public boolean isEscapovat() {
        return escapovat;
    }

    public void setEscapovat(boolean escapovat) {
        this.escapovat = escapovat;
    }
}
