--
-- PostgreSQL database dump
--

-- Started on 2009-05-31 22:35:00 CEST

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 10 (class 2615 OID 16788)
-- Name: sqlvyukaaplikace; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA sqlvyukaaplikace;


SET search_path = sqlvyukaaplikace, pg_catalog;

--
-- TOC entry 1579 (class 1259 OID 16797)
-- Dependencies: 10
-- Name: historie_seq; Type: SEQUENCE; Schema: sqlvyukaaplikace; Owner: -
--

CREATE SEQUENCE historie_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1578 (class 1259 OID 16789)
-- Dependencies: 1848 1849 10
-- Name: historie; Type: TABLE; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

CREATE TABLE historie (
    id numeric DEFAULT nextval('historie_seq'::regclass) NOT NULL,
    datum timestamp with time zone DEFAULT now(),
    sql text,
    id_sezeni character varying(255),
    ip_adresa character varying(255)
);


--
-- TOC entry 1580 (class 1259 OID 16813)
-- Dependencies: 10
-- Name: tip_seq; Type: SEQUENCE; Schema: sqlvyukaaplikace; Owner: -
--

CREATE SEQUENCE tip_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- TOC entry 1581 (class 1259 OID 16815)
-- Dependencies: 1850 10
-- Name: tip; Type: TABLE; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

CREATE TABLE tip (
    id numeric DEFAULT nextval('tip_seq'::regclass) NOT NULL,
    text character varying(512) NOT NULL
);


--
-- TOC entry 1859 (class 0 OID 0)
-- Dependencies: 1581
-- Name: TABLE tip; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON TABLE tip IS 'Rady, tipy, odkazy a citáty… které budeme zobrazovat uživateli v náhodném pořadí.';


--
-- TOC entry 1860 (class 0 OID 0)
-- Dependencies: 1581
-- Name: COLUMN tip.text; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN tip.text IS 'HTML text. Bude vložen do <p>odstavce</p>. → Pozor na validitu.';


--
-- TOC entry 1852 (class 2606 OID 16796)
-- Dependencies: 1578 1578
-- Name: historie_pk; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historie
    ADD CONSTRAINT historie_pk PRIMARY KEY (id);


--
-- TOC entry 1854 (class 2606 OID 16823)
-- Dependencies: 1581 1581
-- Name: tip_pk; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tip
    ADD CONSTRAINT tip_pk PRIMARY KEY (id);


--
-- TOC entry 1856 (class 2606 OID 16825)
-- Dependencies: 1581 1581
-- Name: tip_uq; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tip
    ADD CONSTRAINT tip_uq UNIQUE (text);


-- Completed on 2009-05-31 22:35:01 CEST

--
-- PostgreSQL database dump complete
--

