package cz.frantovo.sql.vyuka.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;

/**
 * Rady, tipy, odkazy, citáty… pro zobrazování uživatelům.
 * @author fiki
 */
public class TipyDAO extends VyukaSuperDAO {

    private enum SQL {

        NAHODNY_TIP
    }

    /**
     * @return Náhodný tip načtený z databáze
     */
    public String getTip() {
        Connection db = getSpojeni(DATABAZE.APLIKACE);
        if (db == null) {
            log.log(Level.SEVERE, "Databáze je null.");
            return null;
        } else {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = db.prepareStatement(getSQL(SQL.NAHODNY_TIP));
                rs = ps.executeQuery();
                rs.next();
                return rs.getString("text");
            } catch (Exception e) {
                log.log(Level.SEVERE, "Chyba při hledání náhodného tipu.", e);
                return null;
            } finally {
                zavri(db, ps, rs);
            }
        }
    }
}
