package cz.frantovo.sql.vyuka.web;

import cz.frantovo.sql.vyuka.dao.HistorieDAO;
import cz.frantovo.sql.vyuka.dao.PiskovisteDAO;
import cz.frantovo.sql.vyuka.dao.PruvodceDAO;
import cz.frantovo.sql.vyuka.dto.Pruvodce;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;

/**
 * Webová beana, která poskytuje data Ajaxovému JSPčku.
 *
 * @author fiki
 */
public class Ajax {

	private final Uzivatel uzivatel = new Uzivatel();
	private String sqlPrikaz;
	private long idPruvodce;
	private String kodPruvodce;

	/**
	 * Nastaví informace o klientovi (uživateli).
	 *
	 * @param ipAdresa IP adresa, ze které přišel HTTP požadavek
	 * @param ipPresmerovano HTTP hlavička x-forwarded-for (přidává proxy).
	 * @param idSezeni javovská HTTP relace
	 */
	public void setKlient(String ipAdresa, String ipPresmerovano, String idSezeni) {
		if (("127.0.0.1".equals(ipAdresa) || "10.0.0.31".equals(ipAdresa)) && ipPresmerovano != null) {
			uzivatel.setIpAdresa(ipPresmerovano);
		} else {
			uzivatel.setIpAdresa(ipAdresa);
		}
		uzivatel.setIdSezeni(idSezeni);
	}

	public void setSqlPrikaz(String sqlPrikaz) {
		this.sqlPrikaz = sqlPrikaz;
	}

	public void setIdPruvodce(long idPruvodce) {
		this.idPruvodce = idPruvodce;
	}

	public void setKodPruvodce(String kodPruvodce) {
		this.kodPruvodce = kodPruvodce;
	}

	/**
	 * @return Historie SQL příkazů daného uživatele.
	 */
	public VysledekSQL getHistorie() {
		HistorieDAO h = new HistorieDAO();
		return h.nactiHistorii(uzivatel);
	}

	/**
	 * Vykoná zadaný SQL příkaz v databázi.
	 *
	 * @return Výsledek dotazu – tabulka, hláška nebo chyba.
	 */
	public VysledekSQL getSQLVysledek() {
		PiskovisteDAO p = new PiskovisteDAO();
		return p.vykonejSQL(sqlPrikaz, uzivatel);
	}

	/**
	 * Načte stránku průvodce – podle ID.
	 *
	 * @return průvodce nebo chybová hláška.
	 */
	public Pruvodce getPruvodcePodleId() {
		PruvodceDAO dao = new PruvodceDAO();
		Pruvodce p = dao.getPruvodce(idPruvodce);
		return osetriChybuPruvodce(p);
	}

	/**
	 * Načte stránku průvodce – podle kódu.
	 *
	 * @param kod kód průvodce, kterého hledáme.
	 * @return průvodce nebo chybová hláška.
	 */
	public Pruvodce getPruvodcePodleKodu() {
		PruvodceDAO dao = new PruvodceDAO();
		Pruvodce p = dao.getPruvodce(kodPruvodce);
		return osetriChybuPruvodce(p);
	}

	/**
	 * Načte stránku průvodce.
	 * idPruvodce = id, ke kterému hledáme předchozí stránku (záznam před).
	 *
	 * @return průvodce nebo chybová hláška.
	 */
	public Pruvodce getPruvodcePredchozi() {
		PruvodceDAO dao = new PruvodceDAO();
		Pruvodce p = dao.getPruvodcePredchozi(idPruvodce);
		return osetriChybuPruvodce(p);
	}

	/**
	 * Načte stránku průvodce.
	 * idPruvodce = id, ke kterému hledáme následující stránku (záznam po).
	 *
	 * @return průvodce nebo chybová hláška.
	 */
	public Pruvodce getPruvodceNasledujici() {
		PruvodceDAO dao = new PruvodceDAO();
		Pruvodce p = dao.getPruvodceNasledujici(idPruvodce);
		return osetriChybuPruvodce(p);
	}

	/**
	 * @param p Stránka průvodce načtená z databáze.
	 * @return zadaná stránka, nebo chybová hláška, pokud bylo načteno „null“
	 */
	private static Pruvodce osetriChybuPruvodce(Pruvodce p) {
		if (p == null) {
			p = new Pruvodce();
			p.setKod("chyba");
			p.setNadpis("pruvodce.chyba.nadpis");
			p.setObsah("pruvodce.chyba.obsah");
			p.setLokalizovat(true);
		}
		return p;
	}
}
