/** Strom je načítaný AJAXem až po načtení stránky, takže je potřeba funkci zavolat ručně */
//pridejUdalost(window,"load",sestavStromy);

function pridejUdalost(o, e, f) {
    if (o.addEventListener) {
        o.addEventListener(e,f,true);
        return true;
    } else if (o.attachEvent) {
        return o.attachEvent("on" + e, f);
    } else {
        return false;
    }
}

function nastavKonstantu(name, val) {
    if (typeof(window[name]) == "undefined" || window[name] == null) {
        window[name] = val;
    }
}

function rozbalStrom(treeId) {
    var ul = document.getElementById(treeId);
    if (ul == null) {
        return false;
    }
    rozbalSbalSeznam(ul, nodeOpenClass);
}

function sbalStrom(treeId) {
    var ul = document.getElementById(treeId);
    if (ul == null) {
        return false;
    }
    rozbalSbalSeznam(ul, nodeClosedClass);
}

function rozbalAzNaPolozku(treeId, itemId) {
    var ul = document.getElementById(treeId);
    if (ul == null) {
        return false;
    }
    var ret = rozbalSbalSeznam(ul, nodeOpenClass, itemId);
    if (ret) {
        var o = document.getElementById(itemId);
        if (o.scrollIntoView) {
            o.scrollIntoView(false);
        }
    }
}

function rozbalSbalSeznam(ul, cName, itemId) {
    if(!ul.childNodes || ul.childNodes.length==0) {
        return false;
    }
    for (var itemi = 0; itemi < ul.childNodes.length; itemi++) {
        var item = ul.childNodes[itemi];

        if (itemId != null && item.id == itemId) {
            return true;
        }

        if (item.nodeName == "LI") {
            var subLists = false;
            for (var sitemi = 0; sitemi<item.childNodes.length; sitemi++) {
                var sitem = item.childNodes[sitemi];
                if (sitem.nodeName=="UL") {
                    subLists = true;
                    var ret = rozbalSbalSeznam(sitem, cName, itemId);
                    if (itemId != null && ret) {
                        item.className = cName;
                        return true;
                    }
                }
            }

            if (subLists && itemId == null) {
                item.className = cName;
            }
        }
    }
}

function sestavStromy() {
    nastavKonstantu("treeClass", "strom");
    nastavKonstantu("nodeClosedClass", "liClosed");
    nastavKonstantu("nodeOpenClass", "liOpen");
    nastavKonstantu("nodeBulletClass", "liBullet");
    nastavKonstantu("nodeLinkClass", "bullet");
    nastavKonstantu("preProcessTrees", true);
    if (preProcessTrees) {
        if (!document.createElement) {
            return;
        }
        uls = document.getElementsByTagName("ul");
        for (var uli = 0; uli < uls.length; uli++) {
            var ul = uls[uli];
            if (ul.nodeName == "UL" && ul.className == treeClass) {
                zpracujStrom(ul);
                ul.style.display = "block";
            }
        }
    }
}

function zpracujStrom(ul) {
    if (!ul.childNodes || ul.childNodes.length==0) {
        return;
    }
    for (var itemi = 0; itemi < ul.childNodes.length; itemi++) {
        var item = ul.childNodes[itemi];
        if (item.nodeName == "LI") {
            var subLists = false;
            for (var sitemi = 0; sitemi < item.childNodes.length; sitemi++) {
                var sitem = item.childNodes[sitemi];
                if (sitem.nodeName == "UL") {
                    subLists = true;
                    zpracujStrom(sitem);
                }
            }
            var s = document.createElement("span");
            var t = '\u00A0';
            s.className = nodeLinkClass;
            if (subLists) {
                if (item.className == null || item.className == "") {
                    item.className = nodeClosedClass;
                }
                if (item.firstChild.nodeName == "#text") {
                    t = t + item.firstChild.nodeValue;
                    item.removeChild(item.firstChild);
                }
                s.onclick = function() {
                    this.parentNode.className = (this.parentNode.className==nodeOpenClass) ? nodeClosedClass : nodeOpenClass;
                    return false;
                }
            } else {
                item.className = nodeBulletClass;
                s.onclick = function() {
                    return false;
                }
            }
            s.appendChild(document.createTextNode(t));
            item.insertBefore(s, item.firstChild);
        }
    }
}
