/** ID html prvků */
const vstupniPole = 'vstupniPole';
const vystupniPole = 'vystupniPole';
const napovedniPole = 'napovedniPole';
const stavovePole = 'stavovePole';


/**
 * Aby to fungovalo i v MSIE 6.
 * @return AJAXový objekt.
 */
function getXmlHttpRequestObject() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    } else if(window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLHTTP");
    } else {
        alert(document.getElementById('lokalizace').nepodporovany.value);
        return null;
    }
}


/** Náš AJAXový objekt. */
var ajax = getXmlHttpRequestObject();


/**
 * Vrací vstup od uživatele.
 * @return SQL příkaz zadaný uživatelem.
 **/
function getSQL() {
    return document.getElementById('aplikace').vstupniPole.value;
}


/**
 * Zobrazí text na požadovaném místě.
 * @param text text k zobrazení. V případě formulářů prostý text, v ostatních případech HTML text.
 * @param kde id prvku, do kterého se má text vypsat.
 **/
function zobraz(text, kde) {
    if (kde == vstupniPole) {
        document.getElementById('aplikace').vstupniPole.value = text;
    } else if (kde == stavovePole)  {
        document.getElementById('aplikace').stavovePole.value = text;
    } else {
        document.getElementById(kde).innerHTML = text + '<p>&nbsp;<!-- Šťastné hackování ;-) --></p>';
    }
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxVykonatSQL() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobraz(document.getElementById('lokalizace').probihaSQL.value, stavovePole);
        ajax.open("POST", 'ajax.jspx?akce=vykonat&sql=' + encodeURIComponent(getSQL()), true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobraz(ajax.responseText, vystupniPole);
                zobraz('', stavovePole);
            }
        };
        ajax.send(null);
    }
    ulozURL();
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxZobrazitHistorii() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobraz(document.getElementById('lokalizace').probihaHistorie.value, stavovePole);
        ajax.open("POST", 'ajax.jspx?akce=historie', true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobraz(ajax.responseText, vystupniPole);
                zobraz('', stavovePole);
            }
        };
        ajax.send(null);
    }
}

var pruvodceAktualniId = 0;
var urlOdkaz = new Array();
urlOdkaz['pruvodce'] = null;

function ajaxPruvodcePredchozi() {
    ajaxPruvodceNaviguj('predchozi', pruvodceAktualniId, null);
}

function ajaxPruvodceZpet() {
    /** TODO: historie navigace */
    alert('Tato funkce se teprve připravuje.');
}

function ajaxPruvodceVpred() {
    /** TODO: historie navigace */
    alert('Tato funkce se teprve připravuje.');
}

function ajaxPruvodceNasledujici() {
    ajaxPruvodceNaviguj('nasledujici', pruvodceAktualniId, null);
}

function ajaxPruvodceKod(kod) {
    ajaxPruvodceNaviguj('podleKodu', 0, kod);
}

function ajaxPruvodceId(id) {
    ajaxPruvodceNaviguj('podleId', id, null);

}

function ajaxPruvodceNaviguj(akcePruvodce, id, kod) {    
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        ajax.open("POST", 'ajax.jspx?akce=napoveda&pruvodce=' + encodeURIComponent(akcePruvodce) + '&idPruvodce=' + encodeURIComponent(id) + '&kodPruvodce=' + encodeURIComponent(kod), true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobraz(ajax.responseText, napovedniPole);
                /** Uložíme si do paměti ID aktuální stránky */
                if (document.pruvodceData) {
                    pruvodceAktualniId = document.pruvodceData.id.value
                } else {
                    pruvodceAktualniId = 0;
                }
                /** Změníme URL v prohlížeči */
                urlOdkaz['pruvodce']  = 'pruvodce=' + encodeURIComponent(pruvodceAktualniId);
                ulozURL();
            }
        };
        ajax.send(null);
    }
}

/**
 * Parametry si ukládáme za # do URL (window.location.hash)
 * Můžeme měnit URL, aniž by prohlížeč obnovoval stránku.
 * Uživatel si může URL zkopírovat a obnovit si příště stav aplikace.
 * @param parametr jméno parametru, který hledáme
 * @return hodnota parametr
 */
function getParametr(parametr) {
    parametr = parametr.replace(/[\[]/,"\\\[").replace(/[\]]/,"\\\]");
    //var regexS = "[\\?&]"+parametr+"=([^&#]*)";
    var regexS = "[\\#&]"+parametr+"=([^&]*)";
    var regex = new RegExp( regexS );
    var results = regex.exec(window.location.hash);
    if( results == null )
        return "";
    else
        return decodeURIComponent(results[1]);
}

/**
 * Uloží parametry (jako je SQL příkaz a stránka průvodce) do URL (za #),
 * aby si uživatel mohl URL zkopírovat a příště si obnovit stav aplikace.
 */
function ulozURL() {
    if (urlOdkaz['pruvodce']) {
        window.location.hash = urlOdkaz['pruvodce'] + '&sql=' + encodeURIComponent(getSQL());
    } else {
        window.location.hash = 'sql=' + encodeURIComponent(getSQL());
    }
}
/**
 * Načte uložený stav aplikace z URL (SQL příkaz, průvodce).
 */
function nactiURL() {
    /** Načteme uživatelův SQL příkaz z URL do vstupního pole */
    if (getParametr('sql')) {
        zobraz(getParametr('sql'), vstupniPole);
    }
    
    /** Načteme pozici v nápovědě */
    if (getParametr('pruvodce')) {
        ajaxPruvodceId(getParametr('pruvodce'));
    } else {
        ajaxPruvodceKod('vitejte');
    }
}

window.onload = function() {
    nactiURL();
}