--
-- PostgreSQL database dump
--

-- Started on 2009-06-06 23:39:14 CEST

SET client_encoding = 'UTF8';
SET standard_conforming_strings = off;
SET check_function_bodies = false;
SET client_min_messages = warning;
SET escape_string_warning = off;

--
-- TOC entry 10 (class 2615 OID 16788)
-- Name: sqlvyukaaplikace; Type: SCHEMA; Schema: -; Owner: -
--

CREATE SCHEMA sqlvyukaaplikace;


SET search_path = sqlvyukaaplikace, pg_catalog;

--
-- TOC entry 1583 (class 1259 OID 16797)
-- Dependencies: 10
-- Name: historie_seq; Type: SEQUENCE; Schema: sqlvyukaaplikace; Owner: -
--

CREATE SEQUENCE historie_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


SET default_tablespace = '';

SET default_with_oids = false;

--
-- TOC entry 1582 (class 1259 OID 16789)
-- Dependencies: 1854 1855 10
-- Name: historie; Type: TABLE; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

CREATE TABLE historie (
    id numeric DEFAULT nextval('historie_seq'::regclass) NOT NULL,
    datum timestamp with time zone DEFAULT now(),
    sql text,
    id_sezeni character varying(255),
    ip_adresa character varying(255)
);


--
-- TOC entry 1586 (class 1259 OID 16826)
-- Dependencies: 10
-- Name: pruvodce_seq; Type: SEQUENCE; Schema: sqlvyukaaplikace; Owner: -
--

CREATE SEQUENCE pruvodce_seq
    INCREMENT BY 10
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- TOC entry 1587 (class 1259 OID 16828)
-- Dependencies: 1857 10
-- Name: pruvodce; Type: TABLE; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

CREATE TABLE pruvodce (
    id numeric DEFAULT nextval('pruvodce_seq'::regclass) NOT NULL,
    kod character varying(32),
    nadpis character varying(255) NOT NULL,
    obsah text NOT NULL
);


--
-- TOC entry 1870 (class 0 OID 0)
-- Dependencies: 1587
-- Name: TABLE pruvodce; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON TABLE pruvodce IS 'Nápověda, průvodce';


--
-- TOC entry 1871 (class 0 OID 0)
-- Dependencies: 1587
-- Name: COLUMN pruvodce.id; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN pruvodce.id IS 'Pořadí kapitoly/lekce';


--
-- TOC entry 1872 (class 0 OID 0)
-- Dependencies: 1587
-- Name: COLUMN pruvodce.kod; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN pruvodce.kod IS 'kód, na který se můžeme odkazovat';


--
-- TOC entry 1873 (class 0 OID 0)
-- Dependencies: 1587
-- Name: COLUMN pruvodce.nadpis; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN pruvodce.nadpis IS 'Název kapitoly';


--
-- TOC entry 1874 (class 0 OID 0)
-- Dependencies: 1587
-- Name: COLUMN pruvodce.obsah; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN pruvodce.obsah IS 'Vlastní text kapitoly';


--
-- TOC entry 1584 (class 1259 OID 16813)
-- Dependencies: 10
-- Name: tip_seq; Type: SEQUENCE; Schema: sqlvyukaaplikace; Owner: -
--

CREATE SEQUENCE tip_seq
    INCREMENT BY 1
    NO MAXVALUE
    NO MINVALUE
    CACHE 1;


--
-- TOC entry 1585 (class 1259 OID 16815)
-- Dependencies: 1856 10
-- Name: tip; Type: TABLE; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

CREATE TABLE tip (
    id numeric DEFAULT nextval('tip_seq'::regclass) NOT NULL,
    text character varying(512) NOT NULL
);


--
-- TOC entry 1875 (class 0 OID 0)
-- Dependencies: 1585
-- Name: TABLE tip; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON TABLE tip IS 'Rady, tipy, odkazy a citáty… které budeme zobrazovat uživateli v náhodném pořadí.';


--
-- TOC entry 1876 (class 0 OID 0)
-- Dependencies: 1585
-- Name: COLUMN tip.text; Type: COMMENT; Schema: sqlvyukaaplikace; Owner: -
--

COMMENT ON COLUMN tip.text IS 'HTML text. Bude vložen do <p>odstavce</p>. → Pozor na validitu.';


--
-- TOC entry 1859 (class 2606 OID 16796)
-- Dependencies: 1582 1582
-- Name: historie_pk; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY historie
    ADD CONSTRAINT historie_pk PRIMARY KEY (id);


--
-- TOC entry 1865 (class 2606 OID 16838)
-- Dependencies: 1587 1587
-- Name: pruvodce_kod_uq; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pruvodce
    ADD CONSTRAINT pruvodce_kod_uq UNIQUE (kod);


--
-- TOC entry 1867 (class 2606 OID 16836)
-- Dependencies: 1587 1587
-- Name: pruvodce_pk; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY pruvodce
    ADD CONSTRAINT pruvodce_pk PRIMARY KEY (id);


--
-- TOC entry 1861 (class 2606 OID 16823)
-- Dependencies: 1585 1585
-- Name: tip_pk; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tip
    ADD CONSTRAINT tip_pk PRIMARY KEY (id);


--
-- TOC entry 1863 (class 2606 OID 16825)
-- Dependencies: 1585 1585
-- Name: tip_uq; Type: CONSTRAINT; Schema: sqlvyukaaplikace; Owner: -; Tablespace: 
--

ALTER TABLE ONLY tip
    ADD CONSTRAINT tip_uq UNIQUE (text);


-- Completed on 2009-06-06 23:39:14 CEST

--
-- PostgreSQL database dump complete
--

