package cz.frantovo.sql.vyuka.dao;

import cz.frantovo.sql.vyuka.dto.Pruvodce;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Level;

/**
 * Načítá průvodce (nápovědu) z databáze.
 * @author fiki
 */
public class PruvodceDAO extends VyukaSuperDAO {

    private enum SQL {

        PODLE_KODU,
        PODLE_ID,
        PODLE_ID_PREDCHOZI,
        PODLE_ID_NASLEDUJICI
    }

    public Pruvodce getPruvodce(long id) {
        return getPruvodce(getSQL(SQL.PODLE_ID), id);
    }

    public Pruvodce getPruvodce(String kod) {
        return getPruvodce(getSQL(SQL.PODLE_KODU), kod);
    }

    public Pruvodce getPruvodcePredchozi(long id) {
        return getPruvodce(getSQL(SQL.PODLE_ID_PREDCHOZI), id);
    }

    public Pruvodce getPruvodceNasledujici(long id) {
        return getPruvodce(getSQL(SQL.PODLE_ID_NASLEDUJICI), id);
    }

    private Pruvodce getPruvodce(String selekt, Object... parametry) {
        Connection db = getSpojeni(DATABAZE.APLIKACE);
        if (db == null) {
            log.log(Level.SEVERE, "Databáze je null.");
            return null;
        } else {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = db.prepareStatement(selekt);
                for (int i = 0; i < parametry.length; i++) {
                    ps.setObject(i + 1, parametry[i]);
                }
                rs = ps.executeQuery();
                if (rs.next()) {
                    Pruvodce p = new Pruvodce();
                    p.setId(rs.getLong("id"));
                    p.setKod(rs.getString("kod"));
                    p.setNadpis(rs.getString("nadpis"));
                    p.setObsah(rs.getString("obsah"));
                    return p;
                } else {
                    return null;
                }
            } catch (Exception e) {
                log.log(Level.SEVERE, "Chyba při hledání průvodce.", e);
                return null;
            } finally {
                zavri(db, ps, rs);
            }
        }
    }
}
