package cz.frantovo.sql.vyuka.web;

import cz.frantovo.sql.vyuka.dao.HistorieDAO;
import cz.frantovo.sql.vyuka.dao.PiskovisteDAO;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;

/**
 * Webová beana, která poskytuje data Ajaxovému JSPčku.
 * @author fiki
 */
public class Ajax {

    private final Uzivatel uzivatel = new Uzivatel();
    private String sqlPrikaz;

    /**
     * Nastaví informace o klientovi (uživateli).
     * @param ipAdresa IP adresa, ze které přišel HTTP požadavek
     * @param ipPresmerovano HTTP hlavička x-forwarded-for
     * @param idSezeni javovská HTTP relace
     */
    public void setKlient(String ipAdresa, String ipPresmerovano, String idSezeni) {
        if ("127.0.0.1".equals(ipAdresa) && ipPresmerovano != null) {
            uzivatel.setIpAdresa(ipPresmerovano);
        } else {
            uzivatel.setIpAdresa(ipAdresa);
        }
        uzivatel.setIdSezeni(idSezeni);
    }

    public void setSqlPrikaz(String sqlPrikaz) {
        this.sqlPrikaz = sqlPrikaz;
    }

    /**
     * @return Historie SQL příkazů daného uživatele.
     */
    public VysledekSQL getHistorie() {
        HistorieDAO h = new HistorieDAO();
        return h.nactiHistorii(uzivatel);
    }

    /**
     * Vykoná zadaný SQL příkaz v databázi.
     * @return Výsledek dotazu – tabulka, hláška nebo chyba.
     */
    public VysledekSQL getSQLVysledek() {
        PiskovisteDAO p = new PiskovisteDAO();
        return p.vykonejSQL(sqlPrikaz, uzivatel);
    }
}
