package cz.frantovo.sql.vyuka.dao;

import cz.frantovo.sql.vyuka.dto.Hlaska;
import cz.frantovo.sql.vyuka.dto.Hlaska.Typ;
import cz.frantovo.sql.vyuka.dto.Tabulka;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.logging.Level;

/**
 * Ukládání a načítání uživatelské historie.
 * @author fiki
 */
public class HistorieDAO extends VyukaSuperDAO {

    TipyDAO tipy = new TipyDAO();

    private enum SQL {

        NACTI,
        ULOZ
    }

    /**
     * @param sql uživatelský SQL příkaz k uložení
     * @param uzivatel idSezení a IP adresa uživatele
     * @return zda se podařilo historii uložit
     */
    public boolean ulozPrikaz(String sql, Uzivatel uzivatel) {
        Connection db = getSpojeni(DATABAZE.APLIKACE);
        if (db == null) {
            return false;
        } else {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = db.prepareStatement(getSQL(SQL.ULOZ));
                ps.setString(1, sql);
                ps.setString(2, uzivatel.getIdSezeni());
                ps.setString(3, uzivatel.getIpAdresa());
                ps.executeUpdate();
                return true;
            } catch (Exception e) {
                log.log(Level.SEVERE, "Chyba při ukládání historie.", e);
                return false;
            } finally {
                zavri(db, ps, rs);
            }
        }
    }

    public VysledekSQL nactiHistorii(Uzivatel uzivatel) {
        VysledekSQL v = new VysledekSQL();


        Tabulka t = new Tabulka();
        String[] zahlavi = {"Kdy", "SQL příkaz"};
        t.setZahlavi(zahlavi);
        /** TODO: lokalizace */
        t.setZahlaviTip("TODO: Překlad");

        Connection db = getSpojeni(DATABAZE.APLIKACE);
        if (db == null) {
            v.getHlasky().add(new Hlaska("Došlo k chybě spojení.", Typ.Chyba));
        } else {
            PreparedStatement ps = null;
            ResultSet rs = null;
            try {
                ps = db.prepareStatement(getSQL(SQL.NACTI));
                ps.setString(1, uzivatel.getIdSezeni());
                rs = ps.executeQuery();

                while (rs.next()) {
                    Timestamp datum = rs.getTimestamp("datum");
                    String sql = rs.getString("sql");
                    Object[] hodnoty = {datum, sql};
                    t.getHodnoty().add(hodnoty);
                }

                if (t.getHodnoty().size() < 1) {
                    v.getHlasky().add(new Hlaska("Historie SQL příkazů nenalezena.", Typ.Varovani));
                } else {
                    v.getTabulky().add(t);
                }

            } catch (Exception e) {
                log.log(Level.SEVERE, "Chyba při ukládání historie.", e);
                v.getHlasky().add(new Hlaska("Došlo k chybě dotazu.", Typ.Chyba));
            } finally {
                zavri(db, ps, rs);
            }
        }

        v.getHlasky().add(new Hlaska(tipy.getTip(), Typ.Tip, false));
        return v;
    }
}
