/** ID html prvků */
const vstupniPole = 'vstupniPole';
const vystupniPole = 'vystupniPole';
const napovedniPole = 'napovedniPole';
const stavovePole = 'stavovePole';


/**
 * Aby to fungovalo i v MSIE 6.
 * @return AJAXový objekt.
 */
function getXmlHttpRequestObject() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    } else if(window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLHTTP");
    } else {
        alert(document.lokalizace.nepodporovany.value);
        return null;
    }
}


/** Náš AJAXový objekt. */
var ajax = getXmlHttpRequestObject();


/**
 * Vrací vstup od uživatele.
 * @return SQL příkaz zadaný uživatelem.
 **/
function getSQL() {
    return document.aplikace.vstupniPole.value;
}


/**
 * Zobrazí text na požadovaném místě.
 * @param text text k zobrazení. V případě formulářů prostý text, v ostatních případech HTML text.
 * @param kde id prvku, do kterého se má text vypsat.
 **/
function zobraz(text, kde) {
    if (kde == vstupniPole) {
        document.aplikace.vstupniPole.value = text;
    } else if (kde == stavovePole)  {
        document.aplikace.stavovePole.value = text;
    } else {
        document.getElementById(kde).innerHTML = text + '<p>&nbsp;<!-- Šťastné hackování ;-) --></p>';
    }
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxVykonatSQL() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobraz(document.lokalizace.probihaSQL.value, stavovePole);
        ajax.open("POST", 'ajax?akce=vykonat&sql=' + encodeURIComponent(getSQL()), true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobraz(ajax.responseText, vystupniPole);
                zobraz('', stavovePole);
            }
        };
        ajax.send(null);
    }
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxZobrazitHistorii() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobraz(document.lokalizace.probihaHistorie.value, stavovePole);
        ajax.open("POST", 'ajax?akce=historie', true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobraz(ajax.responseText, vystupniPole);
                zobraz('', stavovePole);
            }
        };
        ajax.send(null);
    }
}
