/** ID html prvků */
const vstupniPole = 'vstupniPole';
const vystupniPole = 'vystupniPole';
const napovedniPole = 'napovedniPole';
const stavovePole = 'stavovePole';


/**
 * Aby to fungovalo i v MSIE 6.
 * @return AJAXový objekt.
 */
function getXmlHttpRequestObject() {
    if (window.XMLHttpRequest) {
        return new XMLHttpRequest();
    } else if(window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLHTTP");
    } else {
        alert("Váš prohlížeč nepodporuje AJAX. Pořiďte si méně zastaralý prohlížeč, nejlépe Firefox.");
        return null;
    }
}

/** Náš AJAXový objekt. */
var ajax = getXmlHttpRequestObject();

/**
 * Vrací vstup od uživatele.
 * @return SQL příkaz zadaný uživatelem.
 **/
function getSQL() {
    return document.aplikace.vstupniPole.value;
}

/**
 * Zobrazí text na požadovaném místě.
 * @param text text k zobrazení
 * @param kde id prvku, do kterého se má text vypsat
 **/
function zobraz(text, kde) {
    if (kde == vstupniPole) {
        document.aplikace.vstupniPole.value = text;
    } else if (kde == stavovePole)  {
        document.aplikace.stavovePole.value = text;
    } else {
        document.getElementById(kde).innerHTML = text + '<p>&nbsp;<!-- Šťastné hackování ;-) --></p>';
    }
}

/**
 * Zobrazí text ve výstupním poli.
 * @param text HTML text k zobrazení
 **/
function zobrazVystup(text) {
    zobraz(text, vystupniPole);
}

/**
 * Zobrazí text ve vstupním poli.
 * Požijeme pro načtení SQL příkazu z historie.
 * @param text prostý text k zobrazení
 **/
function zobrazVstup(text) {
    zobraz(text, vstupniPole);
}

/**
 * Zobrazí text ve vstupním poli.
 * Požijeme pro načtení SQL příkazu z historie.
 * @param text prostý text k zobrazení
 **/
function zobrazStav(text) {
    zobraz(text, stavovePole);
}

/**
 * Zobrazí text ve poli pro nápovědu.
 * @param text text k zobrazení
 **/
function zobrazNapovedu(text) {
    zobraz(text, napovedniPole);
}

/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxVykonatSQL() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobrazStav('Probíhá zpracování SQL příkazu…');
        ajax.open("POST", 'ajax?akce=vykonat&sql=' + encodeURIComponent(getSQL()), true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobrazVystup(ajax.responseText);
                zobrazStav('');
            }
        };
        ajax.send(null);
    }
}


/** Jednoduchá AJAXová funkce, načte obsah souboru a zobrazí ho ve výstupním okně. */
function ajaxZobrazitHistorii() {
    if (ajax.readyState == 4 || ajax.readyState == 0) {
        zobrazStav('Načítá se historie…');
        ajax.open("POST", 'ajax?akce=historie', true);
        ajax.onreadystatechange = function() {
            if (ajax.readyState == 4) {
                zobrazVystup(ajax.responseText);
                zobrazStav('');
            }
        };
        ajax.send(null);
    }
}
