package cz.frantovo.sql.vyuka.dao;

import cz.frantovo.sql.vyuka.dao.VyukaSuperDAO.DATABAZE;
import cz.frantovo.sql.vyuka.dto.Hlaska;
import cz.frantovo.sql.vyuka.dto.Hlaska.Typ;
import cz.frantovo.sql.vyuka.dto.Tabulka;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;

/**
 * Pro spouštění uživatelových příkazů.
 * @author fiki
 */
public class PiskovisteDAO extends VyukaSuperDAO {

    TipyDAO tipy = new TipyDAO();
    HistorieDAO historie = new HistorieDAO();

    public VysledekSQL vykonejSQL(String sql, Uzivatel uzivatel) {
        VysledekSQL v = new VysledekSQL();
        if (historie.ulozPrikaz(sql, uzivatel)) {

            Connection db = getSpojeni(DATABAZE.PISKOVISTE);
            if (db == null) {
                v.getHlasky().add(new Hlaska("Došlo k chybě spojení.", Typ.Chyba));
            } else {
                PreparedStatement ps = null;
                ResultSet rs = null;
                try {
                    ps = db.prepareStatement(sql);
                    boolean isRS = ps.execute();

                    if (isRS) {
                        rs = ps.getResultSet();
                        v.getTabulky().add(zpracujVysledek(rs));

                        while (ps.getMoreResults()) {
                            rs = ps.getResultSet();
                            v.getTabulky().add(zpracujVysledek(rs));
                        }
                    } else {
                        /** TODO: zobrazit počet aktualizovaných? */
                        v.getHlasky().add(new Hlaska("SQL příkaz byl proveden, ale nevrátil žádná data.", Typ.Varovani));
                    }

                } catch (SQLException e) {
                    log.log(Level.SEVERE, "SQL chyba při vykonávání uživatelského dotazu.", e);
                    v.getHlasky().add(new Hlaska("Chybné SQL: " + e.getMessage(), Typ.Chyba));
                } catch (Exception e) {
                    log.log(Level.SEVERE, "Chyba při vykonávání uživatelského dotazu.", e);
                    v.getHlasky().add(new Hlaska("Došlo k chybě dotazu.", Typ.Chyba));
                } finally {
                    zavri(db, ps, rs);
                }
            }

            v.getHlasky().add(new Hlaska(tipy.getTip(), Typ.Tip, false));

        } else {
            v.getHlasky().add(new Hlaska("Došlo k chybě historie.", Typ.Chyba));
        }
        return v;
    }

    private Tabulka zpracujVysledek(ResultSet rs) throws SQLException {
        Tabulka t = new Tabulka();

        int pocetSloupecku = rs.getMetaData().getColumnCount();
        String[] zahlavi = new String[pocetSloupecku];
        t.setZahlavi(zahlavi);
        for (int i = 0; i < pocetSloupecku; i++) {
            zahlavi[i] = rs.getMetaData().getColumnName(i + 1);
        }

        while (rs.next()) {
            Object[] hodnoty = new Object[pocetSloupecku];
            for (int i = 0; i < pocetSloupecku; i++) {
                hodnoty[i] = rs.getObject(i + 1);
            }
            t.getHodnoty().add(hodnoty);
        }

        return t;
    }
}
