package cz.frantovo.sql.vyuka.dao;

import cz.frantovo.superDAO.SuperDAO;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;

/**
 *
 * @author fiki
 */
public class VyukaSuperDAO extends SuperDAO {

    protected InitialContext kontext = null;

    protected enum DATABAZE {

        /** Databáze aplikace – historie, nastavení. */
        APLIKACE,
        /** Databáze, na které se spouštějí příkazy uživatelů. */
        PISKOVISTE
    }

    public VyukaSuperDAO() {
        try {
            kontext = new InitialContext();
        } catch (NamingException ex) {
            log.log(Level.SEVERE, "Chyba při inicializaci kontextu", ex);
        }
    }

    /**
     * @param databaze Která databáze (aplikace = historie a nastavení | pískoviště = příkazy uživatele)
     * @return Databázové spojení
     */
    protected Connection getSpojeni(DATABAZE databaze) {
        if (databaze == null) {
            databaze = DATABAZE.PISKOVISTE;
        }
        log.log(Level.SEVERE, "DATABAZE:" + String.valueOf(databaze));
        String jndi = orizniJNDI(getVlastnost(databaze, VyukaSuperDAO.class));
        DataSource zdroj = null;
        try {
            zdroj = (DataSource) kontext.lookup(jndi);
            return zdroj.getConnection();
        } catch (NamingException ex) {
            log.log(Level.SEVERE, "getSpojeni: lookup", ex);
            return null;
        } catch (SQLException ex) {
            log.log(Level.SEVERE, "getSpojeni: sql", ex);
            return null;
        }
    }
}