package cz.frantovo.sql.vyuka.ajax;

import cz.frantovo.sql.vyuka.dao.HistorieDAO;
import cz.frantovo.sql.vyuka.dao.PiskovisteDAO;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;

/**
 * Pomocník servletu. Vrací HTML části stránek.
 * @author fiki
 */
public class Ajax {

    /**
     * @return Historie SQL příkazů daného uživatele.
     */
    public String getHistorie(Uzivatel uzivatel) {
        HistorieDAO h = new HistorieDAO();
        VysledekSQL v = h.nactiHistorii(uzivatel);
        return v.getHtml();
    }

    /**
     * Vykoná zadaný SQL příkaz v databázi.
     * @return Výsledek dotazu – tabulka, hláška nebo chyba.
     */
    public String geSQLVysledek(String sql, Uzivatel uzivatel) {
        PiskovisteDAO p = new PiskovisteDAO();
        VysledekSQL v = p.vykonejSQL(sql, uzivatel);
        return v.getHtml();
    }
}
