package cz.frantovo.sql.vyuka.ajax;

import cz.frantovo.sql.vyuka.dto.Hlaska;
import cz.frantovo.sql.vyuka.dto.Hlaska.Typ;
import cz.frantovo.sql.vyuka.dto.Tabulka;
import cz.frantovo.sql.vyuka.dto.Uzivatel;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;

/**
 * Pomocník servletu. Vrací HTML části stránek.
 * @author fiki
 */
public class Ajax {

    /**
     * @return Historie SQL příkazů daného uživatele.
     */
    public String getHistorie(Uzivatel uzivatel) {
        VysledekSQL v = new VysledekSQL();
        v.getHlasky().add(new Hlaska("Bude vypsána vaše historie", Typ.OK));
        v.getHlasky().add(new Hlaska("idSezení: " + uzivatel.getIdSezeni(), Typ.OK));
        v.getHlasky().add(new Hlaska("Ale ještě to není hotové.", Typ.Varovani));
        v.getHlasky().add(new Hlaska("Což je asi chyba.", Typ.Chyba));
        v.getHlasky().add(new Hlaska("Stejně vám něco <a href=\"http://frantovo.cz/blog/\">doporučíme</a>.", Typ.Tip, false));


        Tabulka t = new Tabulka();
        String[] zahlavi = {"Kdy", "SQL příkaz"};
        t.setZahlavi(zahlavi);
        for (int i = 1; i < 4; i++) {
            String[] hodnoty = {"Někdy " + i, "SELECT * FROM tabulka WHERE id = " + i};
            t.getHodnoty().add(hodnoty);
        }
        v.getTabulky().add(t);


        return v.getHtml();
    }

    /**
     * Vykoná zadaný SQL příkaz v databázi.
     * @return Výsledek dotazu – tabulka, hláška nebo chyba.
     */
    public String geSQLVysledek(String sql, Uzivatel uzivatel) {
        VysledekSQL v = new VysledekSQL();
        v.getHlasky().add(new Hlaska("Bude vykonán SQL dotaz.", Typ.OK));
        v.getHlasky().add(new Hlaska("idSezení: " + uzivatel.getIdSezeni(), Typ.OK));
        v.getHlasky().add(new Hlaska("SQL: " + sql, Typ.OK));
        v.getHlasky().add(new Hlaska("IP adresa: " + uzivatel.getIpAdresa(), Typ.OK));
        v.getHlasky().add(new Hlaska("IP adresa a SQL dotaz budou uloženy", Typ.Varovani));
        v.getHlasky().add(new Hlaska("Ale ještě to není hotové.", Typ.Varovani));
        v.getHlasky().add(new Hlaska("Což je asi chyba.", Typ.Chyba));
        v.getHlasky().add(new Hlaska("Stejně vám něco <a href=\"http://frantovo.cz/blog/\">doporučíme</a>.", Typ.Tip, false));

        for (int n = 1; n < 3; n++) {
            Tabulka t = new Tabulka();
            String[] zahlavi = {"Sloupeček 1", "Nějaké číslo"};
            t.setZahlavi(zahlavi);
            for (int i = 1; i < 4; i++) {
                Object[] hodnoty = {"počet " + i, new Integer(i * n)};
                t.getHodnoty().add(hodnoty);
            }
            v.getTabulky().add(t);
        }

        return v.getHtml();
    }
}
