package cz.frantovo.sql.vyuka.dto;

import cz.frantovo.sql.vyuka.Html;

/**
 * Hláška úspěšného provedení.
 * @author fiki
 */
public class Hlaska implements HtmlObjekt {

    private String text;
    private Typ typ;
    private boolean escapovat;

    /**
     * SQL hláška
     * @param text text hlášky
     * @param typ ovlivňuje ikonku
     * @param escapovat zda máme escapovat text kvůli HTML značkám
     */
    public Hlaska(String text, Typ typ, boolean escapovat) {
        this.text = text;
        this.typ = typ;
        this.escapovat = escapovat;
    }

    /**
     * SQL hláška
     * @param text text hlášky
     * @param typ ovlivňuje ikonku
     */
    public Hlaska(String text, Typ typ) {
        this.text = text;
        this.typ = typ;
        this.escapovat = true;
    }

    public String getHtml() {
        String hodnota;
        if (isEscapovat()) {
            hodnota = Html.escapuj(text);
        } else {
            hodnota = text;
        }
        return "<p class=\"vysledek" + getTyp().name() + "\">" + hodnota + "</p>";
    }

    public String getText() {
        return text;
    }

    public void setText(String hodnota) {
        this.text = hodnota;
    }

    public Typ getTyp() {
        return typ;
    }

    public void setTyp(Typ typ) {
        this.typ = typ;
    }

    public boolean isEscapovat() {
        return escapovat;
    }

    public void setEscapovat(boolean escapovat) {
        this.escapovat = escapovat;
    }

    public enum Typ {

        OK,
        Tip,
        Varovani,
        Chyba
    }
}
