package cz.frantovo.sql.vyuka.ajax;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Servlet pro vyřizování AJAXových požadavků.
 * @author fiki
 */
public class Servlet extends HttpServlet {

    private static final long serialVersionUID = 9102108273105288056L;

    private enum akce {

        /** Provede SQL dotaz. */
        vykonat,
        /** Vypíše historii SQL příkazů daného uživatele. */
        historie,
        /** Vypíše nějaké nepotřebné informace. */
        test,
        /** Pokud je požadovaná akce nesmysl. */
        chyba
    }

    /** 
     * Processes requests for both HTTP <code>GET</code> and <code>POST</code> methods.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {

        /** Používáme pouze UTF-8 */
        response.setContentType("text/html;charset=UTF-8");
        request.setCharacterEncoding("UTF-8");

        PrintWriter out = response.getWriter();

        try {

            akce parametrAkce = akce.chyba;
            try {
                parametrAkce = akce.valueOf(request.getParameter("akce"));
            } catch (Exception e) {
                /** Chyba nebo podvržený AJAXový požadavek → zobrazíme chybovou hlášku */
            }


            Ajax a = new Ajax();
            String idSezeni = request.getRequestedSessionId();


            switch (parametrAkce) {
                case vykonat:
                    out.println(a.geSQLVysledek(request.getParameter("sql"), idSezeni));
                    break;
                case historie:
                    out.println(a.getHistorie(idSezeni));
                    break;
                case test:
                    out.println("<p>AJAX jede!</p>");
                    out.println("<ol>");
                    out.println("<li>Metoda: " + request.getMethod() + "</li>");
                    out.println("<li>Host: " + request.getRemoteHost() + "</li>");
                    out.println("<li>Adresa: " + request.getRemoteAddr() + "</li>");
                    out.println("<li>Akce: " + request.getParameter("akce") + "</li>");
                    out.println("<li>SQL: " + request.getParameter("sql") + "</li>");
                    out.println("<li>Sezení: " + request.getRequestedSessionId() + "</li>");
                    out.println("<li>URL: " + request.getRequestURL().toString() + "</li>");
                    out.println("</ol>");
                    break;
                case chyba:
                    out.println("<p>chyba</p>");
                    break;
            }
        } finally {
            out.close();
        }
    }

    // <editor-fold defaultstate="collapsed" desc="HttpServlet methods. Click on the + sign on the left to edit the code.">
    /** 
     * Handles the HTTP <code>GET</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Handles the HTTP <code>POST</code> method.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response)
            throws ServletException, IOException {
        processRequest(request, response);
    }

    /** 
     * Returns a short description of the servlet.
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Servlet pro zpracování AJAXových požadavků.";
    }// </editor-fold>
}
