package cz.frantovo.sql.vyuka.dto;

import cz.frantovo.sql.vyuka.Html;
import java.util.ArrayList;
import java.util.Collection;

/**
 * Tabulka, která je výsledkem SQL dotazu.
 * @author fiki
 */
public class Tabulka implements HtmlObjekt {

    private String[] zahlavi;
    private Collection<Object[]> hodnoty = new ArrayList<Object[]>();

    public String getHtml() {

        if (getZahlavi() == null || getHodnoty() == null || getZahlavi().length < 1) {
            return "<p>Chybná tabulka</p>";
        } else {

            StringBuffer html = new StringBuffer();

            html.append("<table>");


            html.append("<thead title=\"Chceš setřídit výsledek podle nějakého sloupce? Co takhle ORDER BY sloupec.\">");
            html.append("<tr>");
            for (String z : getZahlavi()) {
                html.append("<td>" + Html.escapuj(z) + "</td>");
            }
            html.append("</tr>");
            html.append("</thead>");


            html.append("<tbody>");
            for (Object[] hh : getHodnoty()) {
                for (Object h : hh) {
                    html.append(formatujRadek(h));
                }
            }
            html.append("</tbody>");

            html.append("</table>");


            return html.toString();
        }
    }

    private String formatujRadek(Object o) {
        if (o instanceof Integer) {
            return "<td class=\"cislo\">" + Html.escapuj(String.valueOf(o)) + "</td>";
        } else {
            return "<td>" + Html.escapuj(String.valueOf(o)) + "</td>";
        }
    }

    public String[] getZahlavi() {
        return zahlavi;
    }

    public void setZahlavi(String[] zahlavi) {
        this.zahlavi = zahlavi;
    }

    public Collection<Object[]> getHodnoty() {
        return hodnoty;
    }

    public void setHodnoty(Collection<Object[]> hodnoty) {
        this.hodnoty = hodnoty;
    }
}
