package cz.frantovo.sql.vyuka.ajax;

import cz.frantovo.sql.vyuka.dto.Hlaska;
import cz.frantovo.sql.vyuka.dto.Hlaska.Typ;
import cz.frantovo.sql.vyuka.dto.VysledekSQL;

/**
 * Pomocník servletu. Vrací HTML části stránek.
 * @author fiki
 */
public class Ajax {

    /**
     * @return Historie SQL příkazů daného uživatele.
     */
    public String getHistorie(String idSezeni) {
        VysledekSQL v = new VysledekSQL();
        v.getHlasky().add(new Hlaska("Bude vypsána vaše historie", Typ.OK));
        v.getHlasky().add(new Hlaska("idSezení: " + idSezeni, Typ.OK));
        v.getHlasky().add(new Hlaska("Ale ještě to není hotové.", Typ.Varovani));
        v.getHlasky().add(new Hlaska("Což je asi chyba.", Typ.Chyba));
        v.getHlasky().add(new Hlaska("Stejně vám něco <a href=\"http://frantovo.cz/blog/\">doporučíme</a>.", Typ.Tip));
        return v.getHtml();
    }

    /**
     * Vykoná zadaný SQL příkaz v databázi.
     * @return Výsledek dotazu – tabulka, hláška nebo chyba.
     */
    public String geSQLVysledek(String sql, String idSezeni) {
        VysledekSQL v = new VysledekSQL();
        v.getHlasky().add(new Hlaska("Bude vykonán SQL dotaz.", Typ.OK));
        v.getHlasky().add(new Hlaska("idSezení: " + idSezeni, Typ.OK));
        v.getHlasky().add(new Hlaska("SQL: " + sql, Typ.OK));
        v.getHlasky().add(new Hlaska("Ale ještě to není hotové.", Typ.Varovani));
        v.getHlasky().add(new Hlaska("Což je asi chyba.", Typ.Chyba));
        v.getHlasky().add(new Hlaska("Stejně vám něco <a href=\"http://frantovo.cz/blog/\">doporučíme</a>.", Typ.Tip));
        return v.getHtml();
    }
}
